<?php
global $fm, $config, $str, $myfiles, $settings, $fileman;
$folderRelativePath = $fm->dirname($data['relativePath']);
$folderPath = $fm->dirname($data['filePath']);
$ext = $fm->getExtension($data['fileName']);

$audioFiles = array();
$currentIndex = 0;

if ($ext == "m3u" || $ext == "m3u8") {
	$lines = file($data['filePath']);
	foreach ($lines as $line) {
		if (substr($line, 0, 5) == "http:") {
			$audioFiles[] = array($line, $line);
		}
	}
} else if ($ext == "pls") {
	$lines = file($data['filePath']);
	foreach ($lines as $line) {
		if (substr($line, 0, 4) == "File") {
			$pos = strpos($line, "=");
			$url = substr($line, $pos+1);
			$audioFiles[] = array($url, $url);
		}
	}
} else {
	$list = $fileman->getDirectoryListing($folderPath, false, false, false, true);
	if (is_array($list) && sizeof($list) > 0) {
		$i = 0;
		foreach ($list as $fileName) {
			$filePath = gluePath($folderPath, $fileName);
			$ext = $fm->getExtension($fileName);
			if (in_array($ext, array("mp3", "ogg", "wav", "m4a", "mp4"))) {
				$url = $config['url']['root'];
				$url .= "/?module=fileman&section=utils&page=file_preview&stream=1";
				$url .= "&path=".$str->forURL(gluePath($folderRelativePath, $fileName));
				$audioFiles[$i] = array($url, $fileName);
				if ($fileName == $data['fileName']) {
					$currentIndex = $i;
				}
				$i++;
			}
		}
	}
}

if ($_GET['stream']) {
	global $users, $smarty;
	if ($users->trafficQuota) {
		$filesize = $fm->getFileSize($data['filePath']);
		if (!$users->trafficQuota->canAdd($filesize)) {
			FileRun::displayTrafficLimitPage();
			exit();
		}
	}
	$fm->sendFileToBrowser($data['filePath']);
	if ($users->trafficQuota) {
		$users->trafficQuota->add($fm->bytesSentToBrowser);
	}
} else {
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/> 
    <title></title>
	<link rel="stylesheet" type="text/css" href="css/ext.php?v=<?php echo $settings->currentVersion;?>" />
	<script type="text/javascript" src="js/min.php?extjs=1&v=<?php echo $settings->currentVersion;?>"></script>
	<script src="viewers/mp3/js/soundmanager2-nodebug-jsmin.js"></script>
	<script type="text/javascript" src="viewers/mp3/js/app.js?v=<?php echo $settings->currentVersion;?>"></script>
	<script type="text/javascript">
	var URLRoot = '<?php echo $str->safeJS($config['url']['root'])?>';
	var PopupID = '<?php echo $str->safeJS($popupId)?>';
	FR.popupId = '<?php echo $str->safeJS($popupId)?>';
	FR.countFiles = <?php echo sizeof($audioFiles)?>;
	FR.files = <?php echo json_encode($audioFiles)?>;
	FR.currentIndex = <?php echo $currentIndex?>;
	</script>
	<style>
	.x-grid3-scroller {overflow-x: hidden;}
	</style>
</head>

<body id="theBODY" onload="FR.init()">
</body>
</html>
<?php } ?>