FR = {
	initialized: false, 
	pageIndex: false, fitToPage: true, paused: true, thumbDrag: false, volume: 50,
	init: function() {
		Ext.QuickTips.init();
		this.toolbar = new Ext.Toolbar({
			items: [
			{
				tooltip: 'Previous',
				icon: 'viewers/mp3/images/control_start.png',
				cls: 'x-btn-icon',
				id: 'fr-prev-btn',
				disabled: true,
				handler: this.previousFile, scope: this			
			},{
				tooltip: 'Play',
				icon: 'viewers/mp3/images/control_play.png',
				cls: 'x-btn-icon',
				handler: this.playPause,
				id: 'fr-play-btn', scope: this
			},{
				tooltip: 'Stop',
				icon: 'viewers/mp3/images/control_stop.png',
				cls: 'x-btn-icon',
				id: 'fr-stop-btn', disabled: true,
				handler: this.stopPlayback, scope: this
			},{
				tooltip: 'Next',
				id: 'fr-next-btn',
				icon: 'viewers/mp3/images/control_end.png',
				cls: 'x-btn-icon',
				handler: this.nextFile, scope: this
			},
			'->',
			'<div id="volSlider" style="width:140px;"></div>',
			'<img src="viewers/mp3/images/sound.png" style="margin-right:3px;" />'
		]});
		
		var ds = new Ext.data.ArrayStore({fields: ['url', 'name']});
		ds.loadData(FR.files);
		var cm = new Ext.grid.ColumnModel({
			columns: [new Ext.grid.RowNumberer(), {id: 'name', header: "File name", dataIndex: 'name', width: 400}]
		});
	
		this.grid = new Ext.grid.GridPanel({
			ds: ds,
			cm: cm,
			border: false, bodyBorder: false, hideBorders: true,
			selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
			autoExpandColumn: 'name', hideHeaders: true,
			selModel: new Ext.grid.RowSelectionModel({singleSelect:true})
		});
		
		this.grid.on('rowclick', function (grid, rowIndex, e){
			//var rowData = grid.getStore().data.items[rowIndex].data;
			this.loadFile(rowIndex);
		}, this);
		this.grid.on('rowcontextmenu', function(grid, rowIndex, e) {e.stopEvent();return false;})
		
		this.progress = new Ext.Slider({
			style: 'margin:5px;',
			value: 0,
			minValue: 0,
			maxValue: 100,
			listeners: {
				dragstart: function() {FR.thumbDrag = true;},
				dragend: function() {FR.thumbDrag = false;},
				changecomplete: function(s, newValue) {
					if (!this.paused) {
						this.song.setPosition(newValue/100*FR.duration);
					}
				}, scope: this
			}
		});
		
		this.viewport = new Ext.Viewport({
			layout: 'border',
			hideBorders: true,
			items: [
				{
					region: 'north',
					layout: 'border',
					height: 120,
					items: [
						{
							region: 'north',
							html: '<div style="margin:5px;"><div style="position:relative;height:40px;"><div style="position:absolute;top:0px;right:0px;text-align:right;color:gray;width:90px;" id="loadInfo">&nbsp;</div><div style="font-size:25px;color:gray;overflow:hidden;position:absolute;left:0px;top:0px;width:180px;background-color:white;" id="songDur">00:00 / 00:00</div></div><div style="" id="songInfo">&nbsp;</div></div>',
							bodyStyle: 'font: 11px tahoma,arial,helvetica,sans-serif;background-color:white;',
							height: 60, border: false
						},
						{
							region: 'center',
							bbar: this.toolbar,
							bodyStyle: 'padding:0px;background-color:white;',
							height: 50, border: false,
							items: this.progress
						}
					]
				},
				{
					region: 'center',
					layout: 'fit',
					bodyStyle: 'border-top: 1px solid #D0D0D0;',
					items: this.grid
				}
			]
		});
		this.vol = new Ext.Slider({
			renderTo: 'volSlider',
			tooltip: 'Adjust Volume',
			value: 50,
			minValue: 0,
			maxValue: 100,
			listeners: {
				change: function(s, newValue) {
					FR.song.setVolume(newValue);
					FR.volume = newValue;
				}
			}
		});
		this.grid.getEl().mask('Loading...');
		soundManager.setup({
			url: 'viewers/mp3/swf',
			flashVersion: 9,
			preferFlash: true,
			useFlashBlock: false,
			useHTML5Audio: true,
			debugMode: false,
			onready: function() {
				FR.loadFile(FR.currentIndex);
				FR.grid.getEl().unmask();
			},
			ontimeout: function(status) {
				alert('The audio player failed to start. Is Flash missing or blocked in your browser?');
			}
		});
	},
	stopPlayback: function() {
		Ext.getCmp('fr-play-btn').setIcon('viewers/mp3/images/control_play.png');
		Ext.getCmp('fr-stop-btn').disable();
		this.song.stop();
		this.paused = true;
	},
	playPause: function() {
		if (this.paused) {
			this.play();
		} else {
			Ext.getCmp('fr-play-btn').setIcon('viewers/mp3/images/control_play.png');
			this.song.pause();
			this.paused = true;
		}
	},
	play: function() {
		Ext.getCmp('fr-stop-btn').enable();
		Ext.getCmp('fr-play-btn').setIcon('viewers/mp3/images/control_pause.png');
		soundManager.play('song', {
			onload: function() {
				if (this.readyState == 2) {
					FR.nextFile();
				}
			},
			whileloading: function() {
				var perc = Math.round(this.bytesLoaded/this.bytesTotal*100);
				if (perc < 100) {
					Ext.get('loadInfo').update('Loading: '+perc+'%');
				} else {
					Ext.get('loadInfo').update('');
				}
			},
			onfinish: function() {FR.nextFile();},
			whileplaying: function() {
				if (!FR.thumbDrag) {
					FR.duration = FR.getDurationEstimate(this);
					if (FR.duration) {
						if (FR.progress.disabled) {
							FR.progress.enable();
						}
						var perc = this.position/FR.duration*100;
						FR.progress.setValue(perc);
						Ext.get('songDur').update(FR.formatTime(this.position)+' / '+FR.formatTime(FR.duration));
					} else {
						Ext.get('songDur').update(FR.formatTime(this.position)+' / &infin;');
						if (!FR.progress.disabled) {
							FR.progress.disable();
						}
					}
				}
			},
			onid3: function() {
				if (this.id3.TPE1 || this.id3.TIT2) {
					Ext.get('songInfo').update(this.id3.TPE1+' - '+this.id3.TIT2);
				}
			}
		});
		this.paused = false;
	},
	formatTime: function(ms){
		var s=ms/1000;
		var min=parseInt(s/60);
		var sec=parseInt(s%60);
		return String.leftPad(min,2,'0')+':'+String.leftPad(sec,2,'0');
	},
	getDurationEstimate: function(song) {
		if (song.instanceOptions.isMovieStar) {
			return (song.duration);
		} else {
			return song.durationEstimate || (song.duration || 0);
		}
	},
	loadFile: function(index) {
		this.currentIndex = index;
		if (this.song) {
			this.song.destruct();
		}
		this.song = soundManager.createSound({
			id: 'song',
			url: FR.files[index][0],
			volume: this.volume
		});
		this.play();
		
		Ext.get('songInfo').update(FR.files[index][1]);
		
		if (this.currentIndex < this.countFiles-1) {
			Ext.getCmp('fr-next-btn').enable();
		} else {
			Ext.getCmp('fr-next-btn').disable();
		}
		if (this.currentIndex > 0) {
			Ext.getCmp('fr-prev-btn').enable();
		} else {
			Ext.getCmp('fr-prev-btn').disable();
		}
		this.grid.getSelectionModel().selectRow(index);
	},
	nextFile: function() {
		this.grid.getSelectionModel().selectNext();
		if (this.currentIndex < this.countFiles-1) {
			this.loadFile(this.currentIndex+1);
		}
	},
	previousFile: function() {
		this.grid.getSelectionModel().selectPrevious();
		if (this.currentIndex > 0) {
			this.loadFile(this.currentIndex-1);
		}
	}
}

Ext.override(Ext.dd.DragTracker, {
	onMouseMove: function (e, target) {
		var isIE9 = Ext.isIE && (/msie 9/.test(navigator.userAgent.toLowerCase())) && document.documentMode != 6;
		if (this.active && Ext.isIE && !isIE9 && !e.browserEvent.button) {
			e.preventDefault();
			this.onMouseUp(e);
			return;
		}
		e.preventDefault();
		var xy = e.getXY(), s = this.startXY;
		this.lastXY = xy;
		if (!this.active) {
			if (Math.abs(s[0] - xy[0]) > this.tolerance || Math.abs(s[1] - xy[1]) > this.tolerance) {
				this.triggerStart(e);
			} else {
				return;
			}
		}
		this.fireEvent('mousemove', this, e);
		this.onDrag(e);
		this.fireEvent('drag', this, e);
	}
});