/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSCommand;
import org.apache.commons.net.ftp.FTPSServerSocketFactory;
import org.apache.commons.net.ftp.FTPSSocketFactory;
import org.apache.commons.net.ftp.FTPSTrustManager;
import org.apache.commons.net.net.sf.retrotranslator.runtime.java.lang.Deprecated_;

public class FTPSClient
extends FTPClient {
    @Deprecated_
    public static String KEYSTORE_ALGORITHM;
    @Deprecated_
    public static String TRUSTSTORE_ALGORITHM;
    @Deprecated_
    public static String PROVIDER;
    @Deprecated_
    public static String STORE_TYPE;
    private static final String[] PROT_COMMAND_VALUE;
    private static final String DEFAULT_PROT = "C";
    private static final String DEFAULT_PROTOCOL = "TLS";
    private final boolean isImplicit;
    private final String protocol;
    private String auth = "TLS";
    private SSLContext context;
    private Socket plainSocket;
    private boolean isCreation = true;
    private boolean isClientMode = true;
    private boolean isNeedClientAuth = false;
    private boolean isWantClientAuth = false;
    private String[] suites = null;
    private String[] protocols = null;
    private TrustManager trustManager = new FTPSTrustManager();
    private KeyManager keyManager;

    public FTPSClient() throws NoSuchAlgorithmException {
        this.protocol = DEFAULT_PROTOCOL;
        this.isImplicit = false;
    }

    public FTPSClient(boolean bl) throws NoSuchAlgorithmException {
        this.protocol = DEFAULT_PROTOCOL;
        this.isImplicit = bl;
    }

    public FTPSClient(String string) throws NoSuchAlgorithmException {
        this.protocol = string;
        this.isImplicit = false;
    }

    public FTPSClient(String string, boolean bl) throws NoSuchAlgorithmException {
        this.protocol = string;
        this.isImplicit = bl;
    }

    public FTPSClient(boolean bl, SSLContext sSLContext) {
        this.isImplicit = bl;
        this.context = sSLContext;
        this.protocol = DEFAULT_PROTOCOL;
    }

    public FTPSClient(SSLContext sSLContext) {
        this(false, sSLContext);
    }

    public void setAuthValue(String string) {
        this.auth = string;
    }

    public String getAuthValue() {
        return this.auth;
    }

    protected void _connectAction_() throws IOException {
        if (this.isImplicit) {
            this.sslNegotiation();
        }
        super._connectAction_();
        if (!this.isImplicit) {
            this.execAUTH();
            this.sslNegotiation();
        }
    }

    private void execAUTH() throws SSLException, IOException {
        int n = this.sendCommand(FTPSCommand._commands[0], this.auth);
        if (334 != n && 234 != n) {
            throw new SSLException(this.getReplyString());
        }
    }

    private void initSslContext() throws IOException {
        if (this.context == null) {
            try {
                this.context = SSLContext.getInstance(this.protocol);
                this.context.init(new KeyManager[]{this.getKeyManager()}, new TrustManager[]{this.getTrustManager()}, null);
            }
            catch (KeyManagementException keyManagementException) {
                IOException iOException = new IOException("Could not initialize SSL context");
                iOException.initCause(keyManagementException);
                throw iOException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                IOException iOException = new IOException("Could not initialize SSL context");
                iOException.initCause(noSuchAlgorithmException);
                throw iOException;
            }
        }
    }

    private void sslNegotiation() throws IOException {
        this.plainSocket = this._socket_;
        this.initSslContext();
        SSLSocketFactory sSLSocketFactory = this.context.getSocketFactory();
        String string = this._socket_.getInetAddress().getHostAddress();
        int n = this._socket_.getPort();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this._socket_, string, n, true);
        sSLSocket.setEnableSessionCreation(this.isCreation);
        sSLSocket.setUseClientMode(this.isClientMode);
        if (!this.isClientMode) {
            sSLSocket.setNeedClientAuth(this.isNeedClientAuth);
            sSLSocket.setWantClientAuth(this.isWantClientAuth);
        }
        if (this.protocols != null) {
            sSLSocket.setEnabledProtocols(this.protocols);
        }
        if (this.suites != null) {
            sSLSocket.setEnabledCipherSuites(this.suites);
        }
        sSLSocket.startHandshake();
        this._socket_ = sSLSocket;
        this._controlInput_ = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream(), this.getControlEncoding()));
        this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(sSLSocket.getOutputStream(), this.getControlEncoding()));
    }

    private KeyManager getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setEnabledSessionCreation(boolean bl) {
        this.isCreation = bl;
    }

    public boolean getEnableSessionCreation() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnableSessionCreation();
        }
        return false;
    }

    public void setNeedClientAuth(boolean bl) {
        this.isNeedClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getNeedClientAuth();
        }
        return false;
    }

    public void setWantClientAuth(boolean bl) {
        this.isWantClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getWantClientAuth();
        }
        return false;
    }

    public void setUseClientMode(boolean bl) {
        this.isClientMode = bl;
    }

    public boolean getUseClientMode() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getUseClientMode();
        }
        return false;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.suites = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.suites, 0, stringArray.length);
    }

    public String[] getEnabledCipherSuites() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledCipherSuites();
        }
        return null;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.protocols = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.protocols, 0, stringArray.length);
    }

    public String[] getEnabledProtocols() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledProtocols();
        }
        return null;
    }

    public void execPBSZ(long l) throws SSLException, IOException {
        if (l < 0L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException();
        }
        if (200 != this.sendCommand(FTPSCommand._commands[2], String.valueOf(l))) {
            throw new SSLException(this.getReplyString());
        }
    }

    public void execPROT(String string) throws SSLException, IOException {
        if (string == null) {
            string = DEFAULT_PROT;
        }
        if (!this.checkPROTValue(string)) {
            throw new IllegalArgumentException();
        }
        if (200 != this.sendCommand(FTPSCommand._commands[3], string)) {
            throw new SSLException(this.getReplyString());
        }
        if (DEFAULT_PROT.equals(string)) {
            this.setSocketFactory(null);
            this.setServerSocketFactory(null);
        } else {
            this.setSocketFactory(new FTPSSocketFactory(this.context));
            this.setServerSocketFactory(new FTPSServerSocketFactory(this.context));
            this.initSslContext();
        }
    }

    private boolean checkPROTValue(String string) {
        for (int i = 0; i < PROT_COMMAND_VALUE.length; ++i) {
            if (!PROT_COMMAND_VALUE[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public int sendCommand(String string, String string2) throws IOException {
        int n = super.sendCommand(string, string2);
        if (FTPSCommand._commands[4].equals(string)) {
            if (200 == n) {
                this._socket_ = this.plainSocket;
                this._controlInput_ = new BufferedReader(new InputStreamReader(this._socket_.getInputStream(), this.getControlEncoding()));
                this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._socket_.getOutputStream(), this.getControlEncoding()));
                this.setSocketFactory(null);
            } else {
                throw new SSLException(this.getReplyString());
            }
        }
        return n;
    }

    protected Socket _openDataConnection_(int n, String string) throws IOException {
        Socket socket = super._openDataConnection_(n, string);
        if (socket != null && socket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            sSLSocket.setUseClientMode(this.isClientMode);
            sSLSocket.setEnableSessionCreation(this.isCreation);
            if (!this.isClientMode) {
                sSLSocket.setNeedClientAuth(this.isNeedClientAuth);
                sSLSocket.setWantClientAuth(this.isWantClientAuth);
            }
            if (this.suites != null) {
                sSLSocket.setEnabledCipherSuites(this.suites);
            }
            if (this.protocols != null) {
                sSLSocket.setEnabledProtocols(this.protocols);
            }
            sSLSocket.startHandshake();
        }
        return socket;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    static {
        PROT_COMMAND_VALUE = new String[]{DEFAULT_PROT, "E", "S", "P"};
    }
}

