/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

public class TransferFileFilter
extends FileFilter {
    public static String FILTERSEPARATOR = ",";
    private ArrayList whitelist = null;
    private ArrayList blacklist = null;
    private String wfilter = null;
    private String bfilter = null;
    private Pattern regexpfilter = null;
    private long maxsize = -1L;
    private long minsize = -1L;
    private boolean allowhidden = true;
    private boolean writableDirectoryOnly = false;
    private String description = null;
    private boolean absolute = false;

    public TransferFileFilter(String string, String string2, long l, long l2, String string3, boolean bl) {
        this.wfilter = string2;
        this.bfilter = string;
        this.maxsize = l;
        this.minsize = l2;
        this.initWhitelist();
        this.initBlacklist();
        this.allowhidden = string3 == null || string3.equalsIgnoreCase("accept");
        this.writableDirectoryOnly = bl;
    }

    public TransferFileFilter(String string, String string2, long l, String string3) {
        this(string, string2, l, -1L, string3, false);
    }

    public TransferFileFilter(String string, long l, String string2) {
        this(null, string, l, string2);
    }

    public void initBlacklist() {
        this.absolute = false;
        if (this.bfilter != null) {
            this.blacklist = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.bfilter, FILTERSEPARATOR);
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                this.blacklist.add(string);
            }
        } else {
            this.blacklist = null;
        }
    }

    public void initWhitelist() {
        this.absolute = false;
        if (this.wfilter != null) {
            this.whitelist = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.wfilter, FILTERSEPARATOR);
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                this.whitelist.add(string);
            }
        } else {
            this.whitelist = null;
        }
    }

    public boolean accept(File file) {
        if (this.writableDirectoryOnly) {
            return file.exists() && file.isDirectory() && file.canWrite();
        }
        if (file.isDirectory()) {
            return true;
        }
        return !this.checkBlacklist(file) && this.checkWhitelist(file) && this.checkSize(file) && this.checkMinSize(file) && this.checkHidden(file) && this.checkRegExp(file);
    }

    boolean checkSize(File file) {
        if (this.maxsize > 0L) {
            return file.length() <= this.maxsize;
        }
        return true;
    }

    boolean checkMinSize(File file) {
        if (this.minsize > 0L) {
            return file.length() >= this.minsize;
        }
        return true;
    }

    boolean checkHidden(File file) {
        if (!this.allowhidden) {
            return !file.isHidden();
        }
        return true;
    }

    boolean checkWhitelist(File file) {
        if (file.isFile()) {
            String string = null;
            string = this.absolute ? file.getAbsolutePath() : file.getName();
            return this.checkWhitelist(string);
        }
        return true;
    }

    boolean checkBlacklist(File file) {
        if (file.isFile()) {
            String string = null;
            string = this.absolute ? file.getAbsolutePath() : file.getName();
            return this.checkBlacklist(string);
        }
        return false;
    }

    boolean checkRegExp(File file) {
        if (file.isFile()) {
            String string = null;
            string = this.absolute ? file.getAbsolutePath() : file.getName();
            return this.checkRegExp(string);
        }
        return true;
    }

    boolean checkRegExp(String string) {
        if (this.regexpfilter == null) {
            return true;
        }
        Matcher matcher = this.regexpfilter.matcher(string);
        return !matcher.find();
    }

    boolean checkBlacklist(String string) {
        if (this.blacklist == null) {
            return false;
        }
        return this.checkList(this.blacklist, string);
    }

    boolean checkWhitelist(String string) {
        if (this.whitelist == null) {
            return true;
        }
        return this.checkList(this.whitelist, string);
    }

    boolean checkList(List list, String string) {
        if (list == null) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            String string3 = "";
            String string4 = "";
            int n = string2.lastIndexOf(".");
            if (n != -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1, string2.length());
            }
            String string5 = "";
            String string6 = "";
            n = string.lastIndexOf(".");
            if (n != -1) {
                string5 = string.substring(0, n);
                string6 = string.substring(n + 1, string.length());
            }
            if (string3.equals("*") && string4.equalsIgnoreCase(string6)) {
                bl = true;
                break;
            }
            if (string4.equals("*") && string3.equalsIgnoreCase(string5)) {
                bl = true;
                break;
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.wfilter != null) {
                return this.wfilter;
            }
            if (this.bfilter != null) {
                return this.bfilter;
            }
            return null;
        }
        return this.description;
    }

    public List getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(ArrayList arrayList) {
        this.whitelist = arrayList;
    }

    public List getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(ArrayList arrayList) {
        this.blacklist = arrayList;
    }

    public String getRegExp() {
        return this.regexpfilter.pattern();
    }

    public void setRegExp(String string) {
        if (string != null) {
            this.regexpfilter = Pattern.compile(string);
        }
    }

    public boolean isAbsoluteCheck() {
        return this.absolute;
    }

    public void setAbsoluteCheck(boolean bl) {
        this.absolute = bl;
    }

    public boolean isWritableDirectoryOnly() {
        return this.writableDirectoryOnly;
    }
}

