/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import jfileupload.transfer.client.core.TriggeredInputStream;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.httpclient.methods.multipart.PartSource;

public class CustomFilePartSource
implements PartSource {
    public static boolean FULLNAME = false;
    private File file = null;
    private String fileName = null;
    private String altfileName = null;
    private String fullName = null;
    private List listeners = null;
    private InputStream in = null;
    private long offset = -1L;
    private long maxlength = -1L;
    private Conf conf = null;
    private boolean forceNotification = false;

    public CustomFilePartSource(File file, List list, String string, long l, long l2, Conf conf, boolean bl) throws FileNotFoundException {
        this.file = file;
        this.listeners = list;
        this.conf = conf;
        if (file != null) {
            if (!file.isFile()) {
                throw new FileNotFoundException("Not a file");
            }
            if (!file.canRead()) {
                throw new FileNotFoundException("File is not readable.");
            }
            this.fileName = file.getName();
            this.fullName = file.getAbsolutePath();
            this.altfileName = string;
            this.offset = l;
            this.maxlength = l2;
            this.forceNotification = bl;
        }
    }

    public CustomFilePartSource(File file, List list, String string, long l, long l2, Conf conf) throws FileNotFoundException {
        this(file, list, string, l, -1L, conf, false);
    }

    public CustomFilePartSource(File file, List list, String string, long l) throws FileNotFoundException {
        this(file, list, string, l, -1L, null);
    }

    public CustomFilePartSource(File file, List list, String string) throws FileNotFoundException {
        this(file, list, string, -1L);
    }

    public CustomFilePartSource(File file, List list) throws FileNotFoundException {
        this(file, list, null);
    }

    public CustomFilePartSource(String string, File file) throws FileNotFoundException {
        this(file, null);
        if (string != null) {
            this.fileName = string;
        }
    }

    public long getLength() {
        if (this.file != null) {
            long l = this.file.length();
            if (this.offset > 0L && this.offset < l) {
                l -= this.offset;
            }
            if (this.maxlength > 0L && l > this.maxlength) {
                l = this.maxlength;
            }
            return l;
        }
        return 0L;
    }

    public String getFileName() {
        if (FULLNAME) {
            return this.fullName == null ? "noname" : this.fullName;
        }
        if (this.altfileName != null) {
            return this.altfileName;
        }
        return this.fileName == null ? "noname" : this.fileName;
    }

    public InputStream createInputStream() throws IOException {
        if (this.file != null) {
            this.in = this.conf != null ? this.conf.getTriggeredInputStream((InputStream)new FileInputStream(this.file), this.listeners) : new TriggeredInputStream((InputStream)new FileInputStream(this.file), this.listeners);
            ((TriggeredInputStream)this.in).setMaxlength(this.maxlength);
            ((TriggeredInputStream)this.in).setForceSkipNotification(this.forceNotification);
            if (this.offset > 0L && this.offset < this.file.length()) {
                this.in.skip(this.offset);
            }
            return this.in;
        }
        this.in = new ByteArrayInputStream(new byte[0]);
        return this.in;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

