<?php
/*
	View with Google Docs...
*/
class custom_google_docs_viewer {
	function init() {
		global $locale;
		$this->URL = "https://docs.google.com/viewer";
		$this->JSconfig = array(
			"title" => $locale->get("Google Docs Viewer", 'Custom Actions: Google Docs Viewer'),
			"iconCls" => 'fa fa-fw fa-google',
			"extensions" => array(
				"pdf", "ppt", "pptx", "doc", "docx", "xls", "xlsx", "dxf", "ps", "eps", "xps",
				"psd", "tif", "tiff", "bmp", "svg",
				"pages", "ai", "dxf", "ttf"
			),
			"popup" => true,
			"requiredUserPerms" => array("download")
		);
	}
	function run() {
	$url = $this->weblinks->getOneTimeDownloadLink($this->data['filePath']);
	if (!$url) {
		echo "Failed to setup weblink";
		exit();
	}
	global $log;
	$log->add(false, "preview", array(
		"relative_path" => $this->data['relativePath'],
		"full_path" => $this->data['filePath'],
		"method" => "Google Docs Viewer"
	));
?>
<html>
<head>
	<title></title>
	<style>
		body {
			border: 0px;
			margin: 0px;
			padding: 0px;
			overflow:hidden;
		}
	</style>
</head>

<body>
<iframe scrolling="no" width="100%" height="100%" border="0" src="<?php echo $this->URL?>?url=<?php echo urlencode($url)?>&embedded=true">
</iframe> 
</body>
</html>
<?php
	}
}