<?php
/*
	View with Office Web Viewer...
*/
class custom_office_web_viewer {
	function init() {
		global $locale;
		$proto = isSSL() ? "https" : "http";
		$this->URL = $proto."://view.officeapps.live.com/op/view.aspx";
		$this->JSconfig = array(
			"title" => $locale->get("Office Web Viewer", 'Custom Actions: Office Web Viewer'),
			"iconCls" => 'fa fa-fw fa-cloud',
			"extensions" => array(
				"docx", "docm", "dotm", "dotx",
				"xlsx", "xlsb", "xls", "xlsm",
				"pptx", "ppsx", "ppt", "pps", "pptm", "potm", "ppam", "potx", "ppsm"
			),
			"popup" => true,
			"requiredUserPerms" => array("download")
		);
	}
	function run() {
	$url = $this->weblinks->getOneTimeDownloadLink($this->data['filePath']);
	if (!$url) {
		echo "Failed to setup weblink";
		exit();
	}
	global $log;
	$log->add(false, "preview", array(
		"relative_path" => $this->data['relativePath'],
		"full_path" => $this->data['filePath'],
		"method" => "Office Web Viewer"
	));
?>
<html>
<head>
	<title></title>
	<style>
		body {
			border: 0px;
			margin: 0px;
			padding: 0px;
			overflow:hidden;
		}
	</style>
</head>

<body>
<iframe scrolling="no" width="100%" height="100%" border="0" src="<?php echo $this->URL?>?src=<?php echo urlencode($url)?>">
</iframe> 
</body>
</html>
<?php
	}
}