<?php
class custom_pdfjs {
	function init() {
		global $locale;
		$this->localeSection = "Custom Actions: PDF Viewer";
		$this->JSconfig = array(
			"title" => $locale->get("PDF Viewer", $this->localeSection),
			"iconCls" => 'fa fa-fw fa-file-pdf-o',
			"extensions" => array("pdf"),
			"popup" => true,
			"requiredUserPerms" => array("download")
		);
	}
	function run() {
		$this->checkTrafficUsage();
		require($this->path."/display.php");
	}
	function download() {
		global $log, $fileman, $fm;
		$fileman->checkPerms("download");
		$this->checkTrafficUsage();
		$rs = $fm->sendFileToBrowser($this->data['filePath']);
		if ($users->trafficQuota) {
			$users->trafficQuota->add($fm->bytesSentToBrowser);
		}
		if ($rs && ($rs == "unknown" || $rs == "final")) {
			$log->add(false, "preview", array(
				"relative_path" => $this->data['relativePath'],
				"full_path" => $this->data['filePath'],
				"method" => "PDF Viewer"
			));
		}
	}
	function checkTrafficUsage() {
		global $users, $smarty, $fm, $config;
		if ($users->trafficQuota) {
			$filesize = $fm->getFileSize($this->data['filePath']);
			if (!$users->trafficQuota->canAdd($filesize)) {
				FileRun::displayTrafficLimitPage();
				exit();
			}
		}
	}
}