<?php
/*
	Edit image files with Pixlr.com
*/
class custom_pixlr {
	function init() {
		global $locale;
		$this->localeSection = "Custom Actions: Pixlr";
		$this->JSconfig = array(
			"title" => $locale->get("Pixlr", $this->localeSection),
			"iconCls" => 'fa fa-fw fa-file-image-o',
			"extensions" => array("jpg", "jpeg", "gif", "png", "psd", "bmp", "pxd"),
			"popup" => true,
			"requiredUserPerms" => array("download", "upload"),
			"createNew" => array(
				"title" => $locale->get("Image with Pixlr", $this->localeSection),
				"defaultFileName" => $locale->get("Untitled.png", $this->localeSection)
			)
		);
		$this->outputName = "image";
	}
	function run() {
		if (!is_file($this->data['filePath'])) {
			echo "File not found!";
			exit();
		}
		global $fm, $log;
		$weblinkInfo = $this->weblinks->createForService($this->data['filePath'], false, $fm->dirname($this->data['relativePath']));
		if (!$weblinkInfo) {
			echo "Failed to setup weblink";
			exit();
		}
		$this->data['fileURL'] = $this->weblinks->getURL(array("id_rnd" => $weblinkInfo['id_rnd']));
		$this->data['saveURL'] = $this->weblinks->getSaveURL($weblinkInfo['id_rnd'], false, "pixlr");
		require($this->path."/display.php");
		$log->add(false, "preview", array(
			"relative_path" => $this->data['relativePath'],
			"full_path" => $this->data['filePath'],
			"method" => "Pixlr"
		));
	}
	function createBlankFile() {
		global $myfiles, $users, $locale, $fm;
		if (!$users->userPerms->currentUser['upload']) {exit();}
		$blankFilePath = gluePath($this->path, "blank.png");
		$rs = $myfiles->newFile($fm->dirname($this->data['relativePath']), $this->data['fileName'], $blankFilePath);
		if ($rs) {
			jsonOutput(array("rs" => true, 'path' => $this->data['relativePath'], "filename" => $this->data['fileName'], "msg" => $locale->get("Blank image created successfully", $this->localeSection)));
		} else {
			jsonOutput(array("rs" => false, "msg" => $myfiles->error['msg']));
		}
	}
	function getNewFileContents() {
		global $str;
		$imageURL = $str->fromHTML($_GET['image']);
		return file_get_contents($imageURL);
	}
}