<?php
class custom_webodf {
	function init() {
		global $locale;
		$this->localeSection = "Custom Actions: OpenDocument Viewer";
		$this->JSconfig = array(
			"title" => $locale->get("OpenDocument Viewer", $this->localeSection),
			'iconCls' => 'fa fa-fw fa-file-text-o',
			"extensions" => array("odt", "ods", "odp"),
			"popup" => true,
			"requiredUserPerms" => array("download")
		);
	}
	function run() {
		require($this->path."/display.php");
	}
	function download() {
		global $log, $fileman, $fm;
		$fileman->checkPerms("download");
		$fm->sendFileToBrowser($this->data['filePath']);
		$log->add(false, "preview", array(
			"relative_path" => $this->data['relativePath'],
			"full_path" => $this->data['filePath'],
			"method" => "OpenDocument Viewer"
		));
	}
}