Ext.ns('FR');
var FR = {
	UI: {
		markRequired: ' <em>*</em>'
	},
	components:{},
	selection: {},
	utils: {
		getAjaxOutput: function (url, params, loadingEl) {
			if (this.checkingPath) {
				return false;
			}
			this.checkingPath = true;
			loadingEl.setValue('<img src="'+FR.URLRoot+'/images/generic/loading.gif" border="0">');
			Ext.Ajax.request({
				url: url,
				params: params,
				callback: function() {},
				success: function(req) {
					this.checkingPath = false;
					loadingEl.setValue(req.responseText);
				},
				failure: function(f, a) {FR.feedback(f.responseText);},
				scope: this
			});
		}
	}, 
	trans: []
};
Ext.onReady(function() {
	FR.modules = {
		users: {
			type: 'grid',
			title: FR.T('Users'),
			iconCls: 'iconUser', dblClickEdit: true,
			url: {
				list: '/?module=users&section=cpanel&page=list',
				edit: '/?module=users&section=cpanel&page=edit',
				add:  '/?module=users&section=cpanel&page=add'
			},
			loginAs: true, viewLog: true,
			deleteAction: function(sel) {
				FR.deleteUsersDlg = new Ext.Window({
					title: FR.T('Please confirm the deletion of the selected users'),
					resizable: false, constrain:true, constrainHeader: true,
					minimizable: false, maximizable: false, modal: true, buttonAlign: "left",
					width:450, height:190,
					footer: true, closable: false, layout: 'fit', bodyBorder: false, bodyStyle: 'background-color:white;padding:10px;',
					items: [{ref: 'delHF', xtype: 'checkbox', boxLabel: FR.T('Permanently delete the users home folders.')}],
					buttons: [
						{text: FR.T('Delete'), cls: 'fr-btn-default fr-btn-primary', handler: function() {
							var params = {'uid[]':[]};
							Ext.each(sel, function(item) {
								params['uid[]'].push(item.data.id);
							});
							if (FR.deleteUsersDlg.delHF.getValue()) {
								params.deleteHomeFolder = 1;
							}
							FR.deleteUsersDlg.close();
							Ext.getCmp('gridTabPanel').el.mask('Deleting users...');
							Ext.Ajax.request({
								url: FR.URLRoot+'/?module=users&section=cpanel&page=delete',
								params: params,
								callback: function() {Ext.getCmp('gridTabPanel').el.unmask();},
								success: function(req) {
									try {
										var rs = Ext.util.JSON.decode(req.responseText);
									} catch (er){return false;}
									if (rs) {
										FR.feedback(rs.msg);
										if (rs.success) {
											FR.grid.panel.store.reload();
										}
									} else {FR.feedback(req.responseText);}
								},
								failure: function(f, a) {FR.feedback(f.responseText);},
								scope: this
							});

						}, scope: this},
						{text: FR.T('Cancel'), cls: 'fr-btn-default', handler: function(){FR.deleteUsersDlg.close();}, scope: this}
					]
				}).show();
			}
		},
		roles: {
			type: 'grid',
			title: FR.T('Roles'),
			iconCls: 'iconRole', dblClickEdit: true,
			url: {
				list: '/?module=user_roles&section=cpanel&page=list',
				edit: '/?module=user_roles&section=cpanel&page=edit',
				add:  '/?module=user_roles&section=cpanel&page=add'
			}
		},
		groups: {
			type: 'grid',
			title: FR.T('Groups'),
			iconCls: 'iconGroup', dblClickEdit: true,
			url: {
				list: '/?module=user_groups&section=cpanel&page=list',
				edit: '/?module=user_groups&section=cpanel&page=edit',
				add:  '/?module=user_groups&section=cpanel&page=add'
			}
		},
		notifications: {
			type: 'grid',
			title: FR.T('E-mail notifications'),
			iconCls: 'emailNotif', dblClickEdit: true,
			url: {
				list: '/?module=notifications&section=cpanel&page=list',
				edit: '/?module=notifications&section=cpanel&page=edit',
				add:  '/?module=notifications&section=cpanel&page=add'
			}
		},
        notif_logs: {
            type: 'grid',
            title: FR.T('E-mail notifications logs'),
            iconCls: 'iconLogs', dblClickEdit: true,
            url: {
                list: '/?module=notifications&section=cpanel&page=logslist',
                view: '/?module=notifications&section=cpanel&page=logview'
            }
        },
		logs: {
			type: 'grid',
			title: FR.T('Activity logs'),
			iconCls: 'iconLogs',
			url: {
				list: '/?module=logs&section=cpanel&page=list',
				search: '/?module=logs&section=cpanel&page=search'
			},
			archiveLogsAction: function() {
				new Ext.ux.prompt({text: FR.T('Please confirm the archiving and deletion of the activity logs.'), confirmHandler: function() {
					Ext.Ajax.request({
						url: FR.URLRoot+
						'/?module=logs&section=cpanel&page=archive&action=archive',
						method: 'GET',
						success: function(result, request) {
							try {
								rs = Ext.util.JSON.decode(result.responseText);
							} catch(er) {}
							if (rs) {
								if (rs.success) {
									FR.feedback(rs.msg);
									FR.grid.panel.store.reload();
								} else {
									FR.feedback(rs.msg);
								}
							}
						}
					});
				}});
			}
		},
		metadata_filetypes: {
			type: 'grid',
			title: FR.T('File types'),
			iconCls: 'metaTypes', dblClickEdit: true,
			url: {
				list: '/?module=metadata&section=cpanel&page=list_filetypes',
				edit: '/?module=metadata&section=cpanel&page=edit_filetype',
				add:  '/?module=metadata&section=cpanel&page=add_filetype'
			}
		},
		metadata_fieldsets: {
			type: 'grid',
			title: FR.T('Field sets'),
			iconCls: 'metaSets', dblClickEdit: true,
			url: {
				list: '/?module=metadata&section=cpanel&page=list_fieldsets',
				edit: '/?module=metadata&section=cpanel&page=edit_fieldset',
				add:  '/?module=metadata&section=cpanel&page=add_fieldset'
			}
		},
		metadata_fields: {
			url: {
				edit: '/?module=metadata&section=cpanel&page=edit_field',
				add:  '/?module=metadata&section=cpanel&page=add_field',
				del:  '/?module=metadata&section=cpanel&page=delete_field'
			}
		},
		weblinks: {
			type: 'grid',
			title: FR.T('Web Links'),
			iconCls: 'iconWebLinks', dblClickEdit: true,
			url: {
				list: '/?module=weblinks&section=cpanel&page=list',
				del:  '/?module=weblinks&section=cpanel&page=delete'
			},
			onContextMenu: function (m, grid, rowIndex, e) {
				if (!this.contextMenu) {
					this.contextMenu =  new Ext.menu.Menu({
					    items: [
							{
								text: FR.T('Open Web Link'),
								iconCls: 'fa fa-fw fa-external-link',
								handler: function() {
									window.open(FR.grid.panel.currentSelection.data.url);
								}
							},
							{
								text: FR.T('Delete Web Link'),
								iconCls: 'fa fa-fw fa-unlink',
								handler: function() {
									new Ext.ux.prompt({text: FR.T('Please confirm web link deletion'), confirmHandler: function() {
										Ext.Ajax.request({
											url: FR.URLRoot+
											'/?module=weblinks&section=cpanel&page=delete&id='+
											FR.grid.panel.currentSelection.data.id,
											method: 'GET',
											success: function(result, request) {
												try {
													rs = Ext.util.JSON.decode(result.responseText);
												} catch(er) {}
												if (rs) {
													if (rs.success) {
														FR.feedback(rs.msg);
														FR.grid.panel.store.reload();
													} else {
														FR.feedback(rs.msg);
													}
												}
											}
										});
									}});
								}
							}
						]
					});
				}
				grid.selModel.selectRow(rowIndex);
				var pos = e.getXY();
				this.contextMenu.showAt([pos[0]+3, pos[1]+3]);
			}
		},
		oauth2_clients: {
			type: 'grid',
			title: FR.T('OAuth2 clients'),
			iconCls: 'iconOauth', dblClickEdit: true,
			url: {
				list: '/?module=oauth&section=cpanel&page=client_list',
				edit: '/?module=oauth&section=cpanel&page=client_edit',
				add:  '/?module=oauth&section=cpanel&page=client_add'
			}
		}
	};

	Ext.QuickTips.init();
	FR.initGrid();
	FR.initTree();
	FR.initLayout();
	if (FR.system.isTrial) {
		var d = Ext.util.Format.date(new Date(FR.system.isTrial*1000));
		new Ext.ux.prompt({
			title: 'FileRun Licensing',
			text: 'This FileRun trial license will expire on '+d+'<br>Would you like to upgrade now?',
			confirmHandler: function() {
				window.parent.document.location.href = 'http://www.filerun.com/client-area';
			}
		});
	}
});