function insertTooltipHelpButton(text, appendTo, style) {
	var img = Ext.DomHelper.createDom({
		tag: 'img', src: 'images/fileman/interface/icons/q.gif', width: 16, height: 16,
		style: 'position:absolute;width:16px;height:16px;'+style
	});
	appendTo.appendChild(img);
	var opts = {
		target: Ext.get(img),
		anchor: 'left', showDelay: 0
	};
	if (Ext.isObject(text)) {
		opts = Ext.apply(opts, text);
	} else {
		opts = Ext.apply(opts, {html: text});
	}
	new Ext.ToolTip(opts);
}

Ext.override(Ext.form.Field, {
	afterRender: function(){
		if (this.helpText) {
			insertTooltipHelpButton(this.helpText, this.getErrorCt(), 'top:0;right:0px;');
        }
		Ext.form.Field.superclass.afterRender.call(this);
		this.initValue();
		this.initEvents();
	}
});

headerToolTip = (function() {
	return {
		init: function(p) {
			p.on('afterrender', function() {
				if (this.helpText) {
					insertTooltipHelpButton(this.helpText, this.header, 'top:3;right:16px;');
		        }
			});
		}
	};
});