FR.editSettings = {};
FR.editSettings.formPanel = new FR.components.editForm({
	title: FR.T('File indexing and searching'),
	layout: 'form', bodyStyle: 'padding:10px;',
	defaults: {width: 250}, autoScroll: true,
	items: [
		{
			xtype: 'fieldset',
			checkboxToggle: {tag: 'input', type: 'checkbox', name: this.checkboxName || this.id + '-checkbox', id: 'settings[search_enable]'}, 
			checkboxName: 'settings[search_enable]',
			title: FR.T('Enable file indexing.'), animCollapse: true,
			collapsed: !parseInt(FR.settings.search_enable),
			labelWidth: 200,
			width: 600, defaults: {width: 350},
			items: [
				{
					xtype: 'textarea', height: 100, 
					fieldLabel: FR.T('Binary to text converters'),
					name: 'settings[search_converters_text]', value: FR.settings.search_converters_text,
					listeners: {
						'afterrender': function() {
							this.el.dom.wrap = "off";
						}
					}
				}
			]
		}
	],
	tbar: [
		{
			text: FR.T('Save Changes'),
			iconCls: 'fa fa-fw fa-save',
			ref: 'saveBtn',
			handler: function() {
				var editForm = this.ownerCt.ownerCt;
				var params = editForm.form.getFieldValues();
				var extra = {};
				extra['settings[search_enable]'] = Ext.get('settings[search_enable]').dom.checked ? 1:0;
				Ext.apply(params, extra);
				var opts = {
					url: FR.URLRoot+'/?module=cpanel&section=settings&action=save',
					maskText: 'Saving changes...',
					params: params
				};
				editForm.submitForm(opts);
			}
		}
	]
});
Ext.getCmp('appTab').add(FR.editSettings.formPanel);
Ext.getCmp('appTab').doLayout();