Ext.ux.prompt = Ext.extend(Ext.Window, {
	modal: true, closable: false, resizable: false,
	initComponent: function() {
		if (!this.width) {
			this.width = 310;
		}
		var items = [];
		this.btnLabels = {
			confirm: FR.T('Ok'),
			cancel: FR.T('Cancel')
		};
		if (this.text) {
			items.push({xtype: 'displayfield', value: this.text});
		}
		if (this.defaultValue) {
			this.input = new Ext.form.TextField({
				width: 265, style: 'font-size:14px;height:25px;',
				value: this.defaultValue, allowBlank: false
			});
			this.selectField = new Ext.util.DelayedTask(function(){
				this.input.focus(true);
				var dotpos = this.defaultValue.lastIndexOf(".");
				if (dotpos !== -1) {
					this.input.selectText(0, dotpos);
				} else {
					this.input.selectText();
				}
			}, this);
			items.push(this.input);
		} else {
			if (!this.callback && this.confirmHandler) {
				this.btnLabels = {
					confirm: FR.T('Yes'),
					cancel: FR.T('No')
				};
			}
		}
		var buttons = [];
		buttons.push({
			text: this.btnLabels.confirm, cls: 'fr-btn-default fr-btn-primary',
			handler: function() {
				if (this.input && !this.input.isValid()) {
					return false;
				}
				this.doAction(this.confirmHandler);
			}, scope: this
		});
		if (this.confirmHandler || this.cancelHandler) {
			buttons.push({text: this.btnLabels.cancel, cls: 'fr-btn-default', handler: function() {this.doAction(this.cancelHandler);}, scope: this});
		}
		Ext.apply(this, {
			items: {
				layout: 'form', bodyStyle: 'padding: 20px 15px', border: false, defaults: {hideLabel: true},
				items: items
			},
			buttons: buttons,
			keys: [
				{
					'key': Ext.EventObject.ENTER,
					'fn': function() {
						if (this.input && !this.input.isValid()) {
							return false;
						}
						this.doAction(this.confirmHandler);
					},'scope': this
				},
				{
					'key': Ext.EventObject.ESC,
					'fn': function() {
						this.doAction(this.cancelHandler);
					},'scope': this
				}
			],
			listeners: {
				'show': function() {if (this.input) {this.selectField.delay(200);}}
			}
		});
		Ext.ux.prompt.superclass.initComponent.apply(this, arguments);
		this.show();
	},
	doAction: function(handler) {
		if (handler) {
			var scope = this.scope || this;
			var params = [];
			if (this.input) {
				params = [this.input.getValue(), this.defaultValue];
			}
			Ext.createDelegate(handler, scope, params)();
		}
		this.close();
	},
	close: function() {
		Ext.ux.prompt.superclass.close.apply(this, arguments);
	}
});