if (Ext.isIE9) {
	Ext.dd.DragTracker.override({
		onMouseMove: function(e, target){
			// HACK: IE hack to see if button was released outside of window. */
			if(this.active && Ext.isIE && !e.browserEvent.button && !Ext.isIE9){
				e.preventDefault();
				this.onMouseUp(e);
				return;
			}
			e.preventDefault();
			var xy = e.getXY(), s = this.startXY;
			this.lastXY = xy;
			if(!this.active){
				if(Math.abs(s[0]-xy[0]) > this.tolerance || Math.abs(s[1]-xy[1]) > this.tolerance){
					this.triggerStart(e);
				}else{
					return;
				}
			}
			this.fireEvent('mousemove', this, e);
			this.onDrag(e);
			this.fireEvent('drag', this, e);
		}
	});
}
Ext.override(Ext.form.Checkbox, {
    submitOffValue: 0, submitOnValue: 1,
    getValue : function() {return this.checked ? this.submitOnValue : this.submitOffValue;}
});

Ext.override(Ext.Window, {shadow: false});
Ext.override(Ext.menu.Menu, {shadow: false});
Ext.override(Ext.menu.Item, {
	onRender: function(container, position){
		this.itemTpl = new Ext.XTemplate(
			'<a class="{cls} x-unselectable" hidefocus="true" unselectable="on">',
				'<i class="x-menu-item-icon fa fa-fw {iconCls}"></i>',
				'<span class="x-menu-item-text">{text}</span>',
				'<i class="x-menu-item-the-arrow fa fa-chevron-right"></i>',
			'</a>'
		);
		var a = this.getTemplateArgs();
		this.el = position ? this.itemTpl.insertBefore(position, a, true) : this.itemTpl.append(container, a, true);
		this.iconEl = this.el.child('.x-menu-item-icon');
		this.textEl = this.el.child('.x-menu-item-text');
		Ext.menu.Item.superclass.onRender.call(this, container, position);
	}
});
Ext.override(Ext.Button, {
	buttonSelector: 'i',
	template: new Ext.Template('<div id="{4}" class="frBtn"><i class="{3}"></i><span></span></div>'),
	setText : function(text) {
		this.text = text;
		this.textEl = this.el.child('span');
		if (this.textEl) {
			this.textEl.update(text);
		}
		this.doAutoWidth();
		return this;
	}
});

Ext.override(Ext.PagingToolbar, {
	initComponent : function(){
		var T = Ext.Toolbar;
		var pagingItems = [this.first = new T.Button({
			tooltip: this.firstText,
			overflowText: this.firstText,
			iconCls: 'fa fa-fw fa-step-backward',
			cls: 'fr-btn-pagingtbar', disabled: true,
			handler: this.moveFirst, scope: this
		}), this.prev = new T.Button({
			tooltip: this.prevText,
			overflowText: this.prevText,
			iconCls: 'fa fa-fw fa-caret-left fa-lg',
			cls: 'fr-btn-pagingtbar', disabled: true,
			handler: this.movePrevious, scope: this
		}), '-', this.beforePageText,
			this.inputItem = new Ext.form.NumberField({
				cls: 'x-tbar-page-number',
				allowDecimals: false, allowNegative: false, enableKeyEvents: true, selectOnFocus: true, submitValue: false,
				listeners: {
					scope: this,
					keydown: this.onPagingKeyDown,
					blur: this.onPagingBlur
				}
			}), this.afterTextItem = new T.TextItem({
				text: String.format(this.afterPageText, 1)
			}), '-', this.next = new T.Button({
				tooltip: this.nextText,
				overflowText: this.nextText,
				iconCls: 'fa fa-fw fa-caret-right fa-lg',
				cls: 'fr-btn-pagingtbar', disabled: true,
				handler: this.moveNext, scope: this
			}), this.last = new T.Button({
				tooltip: this.lastText,
				overflowText: this.lastText,
				iconCls: 'fa fa-fw fa-step-forward',
				cls: 'fr-btn-pagingtbar', disabled: true,
				handler: this.moveLast, scope: this
			}), '-', this.refresh = new T.Button({
				tooltip: this.refreshText,
				overflowText: this.refreshText,
				iconCls: 'fa fa-fw fa-refresh',
				cls: 'fr-btn-pagingtbar',
				handler: this.doRefresh, scope: this
			})];
		var userItems = this.items || this.buttons || [];
		if (this.prependButtons) {
			this.items = userItems.concat(pagingItems);
		}else{
			this.items = pagingItems.concat(userItems);
		}
		delete this.buttons;
		if(this.displayInfo){
			this.items.push('->');
			this.items.push(this.displayItem = new T.TextItem({}));
		}
		Ext.PagingToolbar.superclass.initComponent.call(this);
		this.addEvents('change', 'beforechange');
		this.on('afterlayout', this.onFirstLayout, this, {single: true});
		this.cursor = 0;
		this.bindStore(this.store, true);
	}
});


Ext.util.Format.fileSize = function(size, formatString) {
	if (size < 1024) {
		return Ext.util.Format.number(size, '0,0') + FR.T(" Bytes");
	} else if (size < 1048576) {
		return Ext.util.Format.number(Math.round(((size * 100) / 1024)) / 100, formatString?formatString:'0,0') + FR.T(" KB");
	} else if (size < 1073741824) {
		if (size < 10485760) {
			var f = formatString?formatString:'0,0.0';
		} else {
			var f = formatString?formatString:'0,0';
		}
		return Ext.util.Format.number(Math.round(((size * 100) / 1048576)) / 100, f) + FR.T(" MB");
	} else if (size < 1099511627776) {
		return Ext.util.Format.number(Math.round(((size * 100) / 1073741824)) / 100, formatString?formatString:'0,0.00') + FR.T(" GB");
	} else {
		return Ext.util.Format.number(Math.round(((size * 100) / 1099511627776)) / 100, formatString?formatString:'0,0.00') + FR.T(" TB");
	}
};

Ext.override(Ext.tree.TreeLoader, {
	processResponse: function(response, node, callback, scope){
		var json = response.responseText;
		try {
			var o = response.responseData || Ext.decode(json);
			if (this.root) {
				this.xtra = o.xtra;
				var o = o[this.root];
			}
			node.beginUpdate();
			for(var i = 0, len = o.length; i < len; i++){
				var n = this.createNode(o[i]);
				if(n){
					node.appendChild(n);
				}
			}
			node.endUpdate();
			this.runCallback(callback, scope || node, [node]);
		}catch(e){
			this.handleFailure(response);
		}
	}
});
Ext.Ajax.timeout = 300000;
Ext.BLANK_IMAGE_URL = 'images/extjs/gray/s.gif';

(function(){
	var userAgent = navigator.userAgent,
		re = new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})"),
		isIE11 = navigator.appName === 'Netscape' && re.exec(userAgent) !== null && parseFloat( RegExp.$1 ) === 11;
	if( isIE11 ){
		Ext.isIE11 = true;
		Ext.ieVersion = 11;
		Ext.isGecko = false;
	} else {
		Ext.isIE11 = false;
	}
})();