var FR = {}
FR.addFolder = function () {
	FR.viewport.mask(FR.T('Sharing folder...'));
	var params = {path: window.parent.FR.BTSync.path};
	var secret = Ext.getCmp('add_with_secret').getValue();
	if (secret) {
		params.secret = secret;
	}
	Ext.Ajax.request({
		url: URLRoot+'/?module=btsync&action=add_folder',
		method: 'post',
		params: params,
		success: function(req){
			FR.viewport.unmask();
			try {
				var rs = Ext.util.JSON.decode(req.responseText);
			} catch (er){return false;}
			if (rs.msg) {
				window.parent.FR.UI.feedback(rs.msg);
			}
			if (!rs.success) {return false;}
			if (rs.secrets.read_only) {
				Ext.getCmp('secretsForm').getForm().setValues(rs.secrets);
				FR.data = {secrets: rs.secrets};
				FR.addFolderForm.hide();
				with (window.parent) {
					if (FR.BTSync.item) {
						if (!FR.BTSync.item.attributes.custom) {FR.BTSync.item.attributes.custom = {};}
						FR.BTSync.item.attributes.custom.sync = 1;
						FR.UI.tree.updateIcon(FR.BTSync.item);
					}
				}
			}
		}
	});
}
FR.getSecrets = function () {
	FR.viewport.mask(FR.T('Updating secrets...'));
	Ext.Ajax.request({
		url: URLRoot+'/?module=btsync&action=get_secrets',
		method: 'post',
		params: {path: window.parent.FR.BTSync.path},
		success: function(req){
			FR.viewport.unmask();
			try {
				var rs = Ext.util.JSON.decode(req.responseText);
			} catch (er){return false;}
			if (!rs) {
				FR.showAddFolderForm();
				with (window.parent) {
					if (FR.BTSync.item && FR.BTSync.item.attributes.custom) {
						FR.BTSync.item.attributes.custom.sync = 0;
						FR.UI.tree.updateIcon(FR.BTSync.item);
					}
				}
				return false;
			}
			if (rs.msg) {
				new Ext.ux.prompt({text: rs.msg});
			}
			if (rs.read_only) {
				Ext.getCmp('secretsForm').getForm().setValues(rs);
				FR.data = {secrets: rs};
			}
		}
	});
}
FR.removeFolder = function () {
	FR.viewport.mask(FR.T('Unsharing folder...'));
	Ext.Ajax.request({
		url: URLRoot+'/?module=btsync&action=remove_folder',
		method: 'post',
		params: {path: window.parent.FR.BTSync.path},
		success: function(req){
			FR.viewport.unmask();
			try {
				var rs = Ext.util.JSON.decode(req.responseText);
			} catch (er){return false;}
			if (rs.msg) {
				window.parent.FR.UI.feedback(rs.msg);
			}
			if (rs.success) {
				with (window.parent) {
					if (FR.BTSync.item && FR.BTSync.item.attributes.custom) {
						FR.BTSync.item.attributes.custom.sync = 0;
						FR.UI.tree.updateIcon(FR.BTSync.item);
					}
				}
				FR.popup.hide();
			}
		}
	});
}
FR.showAddFolderForm = function () {
	if (!FR.addFolderForm) {
		FR.addFolderForm = new Ext.Window({
			title: FR.T('Sync Folder'), closeAction: 'hide', closable: false, draggable: false,
			layout: 'border', width: 340, height: 200, modal: true, hideBorders: true, resizable: false,
			items: [
				{
					region: 'center', layout: 'form', bodyStyle: 'padding:20px',
					items: [
						{
							xtype: 'component',
							autoEl: {html: '<div class="x-form-item">'+FR.T('If you have a secret, paste it here')+':</div>'}
						},
						{
							hideLabel: true, width: 290, id: 'add_with_secret',
							labelSeparator: '', xtype: 'textfield',
							style: 'font-size:14px;text-align:center;', height:28,
							selectOnFocus: true, value: window.parent.Settings.demo_mode?FR.T('OPTION-DISABLED-IN-THIS-DEMO'):'', disabled: window.parent.Settings.demo_mode
						}
					],
					bbar: [
						{
							cls: 'fr-btn-default fr-btn-primary',
							text: FR.T('Start sharing'),
							handler: FR.addFolder
						}
					]
				}
			]
		});
	}
	FR.addFolderForm.show();
}
FR.showQRCodes = function () {
	var base_url = URLRoot +'/?module=btsync&page=qrcode&path='+encodeURIComponent(window.parent.FR.BTSync.path);
	var full_access_url = base_url+'&secret_type=read_write';
	var read_only_url =  base_url+'&secret_type=read_only';
	var full_access_img = '<img src="'+full_access_url+'" id="theQRCode" width="165" height="165">';
	var read_only_img = '<img src="'+read_only_url+'" id="theQRCode" width="165" height="165">';
	if (!FR.QRWindow) {
		FR.QRWindow = new Ext.Window({
			title: FR.T('QR Code'), closeAction: 'hide', draggable: false,
			layout: 'border', width: 250, height: 290, modal: true, hideBorders: true, resizable: false,
			items: [
				{
					region: 'north', bodyStyle: 'padding:3px;text-align:center;', height: 30,
					html: FR.T('Scan this QR code with your mobile device to connect sync folders.')
				},
				{
					region: 'center',
					html: '<div style="text-align:center;"><div style="display:inline-block;background-image:url(images/fileman/interface/thumbnail_loading.gif);background-position: center center;background-repeat:no-repeat;width:165px;height:165px;" id="qrwrap"></div></div>'
				},
				{
					region: 'south', layout: 'form', height: 30, labelWidth: 30,
					items: [
						{
							xtype: 'radiogroup', id: 'radios',
							items: [
								{boxLabel: FR.T('Full Access'), name: 'secret_type', inputValue: 'read_write', checked: true},
								{boxLabel: FR.T('Read Only'), name: 'secret_type', inputValue: 'read_only'}
							],
							listeners: {
								change: function(group, checked) {
									if (checked.getGroupValue() == 'read_only') {
										Ext.get('qrwrap').update(full_access_img);
									} else {
										Ext.get('qrwrap').update(read_only_img);
									}
								}
							}
						}
					]
				}
			]
		});
	}
	FR.QRWindow.show();
	if (FR.data.secrets && FR.data.secrets.read_write) {
		Ext.get('qrwrap').update(full_access_img);
		Ext.getCmp('radios').setValue('read_write');
	} else {
		Ext.get('qrwrap').update(read_only_img);
		Ext.getCmp('radios').setValue('read_only');
		Ext.getCmp('radios').disable();
	}
}

FR.update = function() {
	if (FR.addFolderForm) {FR.addFolderForm.hide();}
	this.getSecrets();
}

Ext.onReady(function() {
	FR.popup = window.parent.FR.UI.popups.BTSync;
	window.parent.Ext.get(FR.popup.getLayout().container.body.dom).unmask();
	var viewport = new Ext.Viewport({
		layout: 'border', hideBorders: true,
		items: [
			{
				region: 'center', layout: 'fit',
				items: {
					xtype: 'tabpanel', activeTab: 0, border: false, id: 'tabPanel',
					items: [
						{
							title: FR.T('Secrets'),
							layout: 'fit',
							items: [
								{
									xtype: 'form', border: false,
									defaultType: 'textfield', id: 'secretsForm',
									bodyStyle: 'padding-top:30px;padding-left:10px;padding-bottom:20px;',
									items: [
										{
											xtype: 'component',
											autoEl: {html: '&nbsp;'}
										},
										{
											xtype: 'component',
											autoEl: {html: '<div class="x-form-item">'+FR.T('Full access secret')+':</div>'}
										},
										{
											hideLabel: true, width: 340,
											labelSeparator: '', name: 'read_write',
											style: 'font-size:14px;text-align:center;'+(window.parent.Settings.demo_mode?'color:gray;':''), height:28,
											selectOnFocus: true, value: ''
										},
										{
											xtype: 'component',
											autoEl: {html: '&nbsp;'}
										},
										{
											xtype: 'component',
											autoEl: {html: '<div class="x-form-item">'+FR.T('Read-only secret')+':</div>'}
										},
										{
											hideLabel: true, width: 340,
											labelSeparator: '', name: 'read_only',
											style: 'font-size:14px;text-align:center;', height:28,
											selectOnFocus: true, value: ''
										}
									]
								}
							],
							bbar: [
								{
									text: FR.T('Options'),
									menu: [
										{
											text: FR.T('Reload secrets'),
											handler: FR.getSecrets
										},
										{
											text: FR.T('Unshare'),
											handler: FR.removeFolder
										}
									]
								},
								'->',
								{
									text: FR.T('Connect mobile device'), scale: 'medium',
									handler: FR.showQRCodes
								}
							]
						},
						{
							title: FR.T('Download BitTorrent Sync'),
							layout: 'fit', bodyStyle: 'padding-top:20px;padding-left:20px',
							html: FR.T('Select your platform or visit the <a href="http://www.bittorrent.com/sync" target="_blank">BitTorrent Sync</a> website:')+' <br>' +
							'<a href="https://itunes.apple.com/us/app/bittorrent-sync/id665156116?mt=8&utm_source=web&utm_medium=dlpop&utm_campaign=iOS" target="_blank"><img src="images/fileman/interface/icons/platforms_ios.png" border="0" /></a>' +
							'<a href="https://play.google.com/store/apps/details?id=com.bittorrent.sync&referrer=utm_source%3Dbittorrent%26utm_medium%3Ddownloads%26utm_campaign%3Dhome" target="_blank"><img src="images/fileman/interface/icons/platforms_android.png" border="0" /></a><br>' +
							'<a href="http://www.getsync.com/download" target="_blank"><img src="images/fileman/interface/icons/platforms_macos.png" border="0" /></a>' +
							'<a href="http://www.getsync.com/download" target="_blank"><img src="images/fileman/interface/icons/platforms_windows.png" border="0" /></a>' +
							'<a href="http://www.getsync.com/download" target="_blank"><img src="images/fileman/interface/icons/platforms_linux.png" border="0" /></a><br>'
						}
					]
				}
			}
		]
	});
	FR.viewport = viewport.el;
	FR.getSecrets();
});