FR.components.detailsPanel = Ext.extend(Ext.Panel, {
	bodyStyle: 'background-color: white',
	metadataCache: new Ext.util.MixedCollection(),
	initComponent: function() {
		this.metaLoaderTask = new Ext.util.DelayedTask(function(){this.loadMeta()}, this);
		this.folderIcon = '<i class="fa fa-folder" style="font-size: 21px;margin-right:5px;color:#8F8F8F"></i>';
		Ext.apply(this, {
			cls: 'fr-details-panel',
			autoScroll: true,
			html:
				'<div id="fr-details-previewbox" class="previewBox" style="visibility:hidden">' +
					'<div class="filename" id="fr-details-filename">&nbsp;</div>' +
					'<div class="thumb" id="fr-details-thumb" style="display:none"></div>' +
				'</div>'+
				'<div id="fr-details-info"></div>'+
				'<div id="fr-details-metadata"></div>',
			listeners: {
				'afterrender': function() {
					this.previewBox = Ext.get('fr-details-previewbox');
					this.fileNameEl = Ext.get('fr-details-filename');
					this.thumbContainer = Ext.get('fr-details-thumb');
					this.thumbContainer.setVisibilityMode(Ext.Element.DISPLAY);
					this.thumbContainer.on('click', function(){
						if (this.item.filetype == 'img') {
							FR.UI.imagePreview.init(this.item);
						} else {
							FR.utils.showPreview(this.item);
						}
					}, this);
					this.infoEl = Ext.get('fr-details-info');
					this.metadataEl = Ext.get('fr-details-metadata');
					this.metadataEl.setVisibilityMode(Ext.Element.DISPLAY);

					this.body.first().on('contextmenu', function() {
						FR.UI.gridPanel.showContextMenu();
					});
				},
				'activate': function(p){
					p.active = true;
					this.gridSelChange();
				},
				'deactivate': function(p) {p.active = false;},
				scope: this
			}
		});
		FR.components.detailsPanel.superclass.initComponent.apply(this, arguments);
	},
	onRender: function() {
		FR.components.detailsPanel.superclass.onRender.apply(this, arguments);
	},
	gridSelChange: function() {
		if (!this.active) {return false;}
		if (!FR.UI.tree.currentSelectedNode) {return false;}
		this.countSel = FR.UI.infoPanel.countSel;
		this.countAll = FR.UI.infoPanel.countAll;
		this.item = FR.UI.infoPanel.item;
		if (this.item) {
			this.itemPath = (this.item.data.path || FR.currentPath+'/'+this.item.data.filename);
		}
		this.updateQuickView();
	},
	reset: function() {
		this.metaLoaderTask.cancel();
		this.metadataEl.update('');
		this.infoEl.update('');
	},
	setItemTitle: function(itemTitle) {
		this.fileNameEl.update(itemTitle);
		this.previewBox.show();
	},
	updateQuickView: function() {
		if (!this.active) {return false;}
		this.reset();

		if (this.countSel == 1) {
			this.metadataEl.show();
			this.loadQuickView();
		} else {
			this.metadataEl.hide();
			this.thumbContainer.hide();
			this.setItemTitle(this.folderIcon+FR.UI.tree.currentSelectedNode.text);

			if (this.countAll == 0) {
				var statusText = FR.T('There are no files in this folder.');
				var size = '';
			} else {
				if (this.countSel == 0) {
					var sel = FR.UI.gridPanel.store.data.items;
					if (this.countAll == 1) {
						statusText = FR.T('One item');
					} else if (this.countAll > 0) {
						statusText = FR.T('%1 items').replace('%1', this.countAll);
					}
				} else {
					var sel = FR.UI.gridPanel.selModel.getSelections();
					statusText = FR.T('%1 items selected').replace('%1', this.countSel);
				}
				var size = 0;
				Ext.each(sel, function (item) {
					if (item.data.isFolder) {
						size = false;
						return false;
					}
					size += parseInt(item.data.filesize);
				});
				if (size > 0) {
					size = Ext.util.Format.fileSize(size);
				} else {
					size = '';
				}
			}
			var info = '<div class="status">' +
				'<div class="text">'+statusText+'</div>' +
				'<div class="size">'+size+'</div>' +
				'<div style="clear:both"></div><div>';
			this.infoEl.update(info);
		}
	},
	loadQuickView: function() {
		var title = this.item.data.isFolder ? this.item.data.filename : FR.utils.dimExt(this.item.data.filename);
		if (this.item.data.isFolder) {
			this.setItemTitle(this.folderIcon+title);
		} else {
			var iconSrc = 'images/fico/' + this.item.data.icon;
			this.setItemTitle('<img src="'+iconSrc+'" height="19" align="left" style="margin-right:5px;" />'+title);
		}
		var imageSrc, width = 256;
		if (this.item.data.thumb) {
			if (this.item.data.thumbImg && (this.item.data.thumbImg.dom.width+this.item.data.thumbImg.dom.height > 0)) {
				imageSrc = this.item.data.thumbImg.dom.src;
			} else {
				imageSrc = iconSrc;
			}
			var img = Ext.DomHelper.createDom({tag: 'img', cls:'detailsThumb', src: imageSrc});
			if (img.width < 256) {width = img.width;}
			img.setAttribute('width', width);
			this.thumbContainer.update('');
			this.thumbContainer.appendChild(img);
			this.thumbContainer.show();
		} else {
			this.thumbContainer.hide();
		}

		var info = '<table cellspacing="1" width="100%">';
		if (this.item.data.path && FR.currentSection != 'trash') {
			info += '<tr>' +
			'<td class="fieldName">'+FR.T('Location')+'</td>' +
			'<td class="fieldValue">'+FR.utils.humanFilePath(this.item.data.path)+'</td>' +
			'</tr>';
		}

		if (FR.currentSection == 'trash') {
			info += '<tr>' +
			'<td class="fieldName">'+FR.T('Deleted from')+'</td>' +
			'<td class="fieldValue">'+this.item.data.trash_deleted_from+'</td>' +
			'</tr>';
		}

		if (!this.item.data.isFolder) {
			info += '<tr>' +
			'<td class="fieldName">' + FR.T('Size') + '</td>' +
			'<td class="fieldValue" title="' + Ext.util.Format.number(this.item.data.filesize, '0,000') + ' ' + FR.T('bytes') + '">' + this.item.data.nice_filesize + '</td>' +
			'</tr>';
		}

		info += '<tr>' +
		'<td class="fieldName">'+FR.T('Type')+'</td>' +
		'<td class="fieldValue">'+this.item.data.type+'</td>' +
		'</tr>';

		if (!this.item.data.isFolder) {
			if (this.item.data.modified.getTime() != this.item.data.created.getTime()) {
				info += '<tr>' +
				'<td class="fieldName">' + FR.T('Date Modified') + '</td>' +
				'<td class="fieldValue">' + this.item.data.modified.format('m/d/Y h:i') + '</td>' +
				'</tr>';
			}
		}

		info += '<tr>' +
		'<td class="fieldName">'+FR.T('Date Created')+'</td>' +
		'<td class="fieldValue">'+this.item.data.created.format('m/d/Y h:i')+'</td>' +
		'</tr>';

		info += '</table>';
		this.infoEl.update(info);

		if (!this.item.data.isFolder) {
			if (this.metadataCache.containsKey(this.itemPath)) {
				this.metadataEl.update(this.metadataCache.get(this.itemPath));
			} else {
				this.metaLoaderTask.delay(500);
			}
		}
	},
	loadMeta: function() {
		if (!this.item) {return false;}
		this.metadataEl.update('<span style="color:silver;font-size:9px;margin:5px;">'+FR.T('Loading metadata...')+'</span>');
		Ext.Ajax.request({
			url: FR.baseURL+'/?module=metadata&page=quick_view',
			params: {path: this.itemPath},
			callback: function(opts, succ, req) {
				if (req.responseText.length > 0) {
					this.metadataCache.add(this.itemPath, req.responseText);
				}
				this.metadataEl.update(req.responseText);
			}, scope: this
		});
	}
});