FR.components.cartPanel = Ext.extend(Ext.Window, {
	closeAction: 'hide',
	initComponent: function() {
		this.store = new Ext.data.ArrayStore({
			fields: ['path', 'displayName', 'icon', 'size'],
			idIndex: 0
		});
		this.listView = new Ext.list.ListView({
			store: this.store,
			hideHeaders: true, singleSelect: true,
			emptyText: '<div style="padding:10px;font-size:13px;color:gray;">'+FR.T('Drag here the files and folders you wish to download')+'</div>',
			columns: [{
				tpl: new Ext.XTemplate(
					'<div style="overflow:hidden;text-overflow:ellipsis;white-space:nowrap;height:16px;margin:2px;">{[this.getIcon(values)]} {displayName}<div style="float:right;color:silver">{size}</div></div>',
					{getIcon: function(values) {
						if (values.icon) {
							return '<img src="images/fico/'+values.icon+'" width="16" height="16" align="absmiddle" />';
						} else {
							return '<i class="fa fa-fw fa-folder colorGray"></i>';
						}
					}}
				)
			}],
			listeners: {
				'afterrender': function() {
					if (this.store.getCount() == 0){this.store.removeAll();}
				},
				'selectionchange': function(list, sel) {
					if (!sel[0]) {return false;}
					var r = list.getRecord(sel[0]);
					var pInfo = FR.utils.pathInfo(r.data.path);
					if (FR.currentPath == pInfo.dirname) {
						FR.UI.gridPanel.highlight(pInfo.basename);
					} else {
						FR.UI.tree.panel.selectPath(pInfo.dirname, 'pathname', function() {
							FR.UI.gridPanel.highlightOnDisplay = pInfo.basename;
						});
					}
				},
				'dblclick': function(list, index) {
					this.store.removeAt(index);
					if (this.store.getCount() == 0) {this.hide();}
				}, scope: this
			}
		});

		Ext.apply(this, {
			width: 320, height: 250, title: FR.T('Download cart'),
			autoScroll: true, layout: 'fit',
			items: this.listView,
			bbar: [
				{text: FR.T('Download all'), cls: 'fr-btn-default fr-btn-primary', handler: function() {this.download();}, scope: this}
			],
			listeners: {
				'hide': function() {this.clear();},
				scope: this
			}
		});
		FR.components.cartPanel.superclass.initComponent.apply(this, arguments);
	},
	onRender: function() {
		FR.components.cartPanel.superclass.onRender.apply(this, arguments);
		var dt = new Ext.dd.DropTarget(this.el, {
			ddGroup: 'TreeDD',
			notifyDrop: Ext.createDelegate(function(dragsource, event, data) {
				if (data.node) {
					if (data.node.attributes.readonly) {
						return false;
					}
					this.addItem(data.node.getPath('pathname'), data.node.attributes.text, false);
				} else {
					if (FR.currentFolderPerms && !FR.currentFolderPerms.download) {
						return false;
					}
					Ext.each(data.selections, function(item) {
						this.addItem((item.data.path || FR.currentPath)+'/'+item.data.filename, item.data.filename, item.data.icon, item.data.nice_filesize);
					}, this);
				}
			}, this),
			notifyEnter: function(source, e, data) {}
		});
	},
	addItem: function(path, displayName, icon, size) {
		var data = {path: path, displayName: displayName, icon: icon, size: size};
		if (!this.store.getById(path)) {
			this.store.insert(0, new Ext.data.Record(data, path));
		}
	},
	clear: function() {this.store.removeAll();},
	download: function() {
		var paths = [];
		this.store.each(function(item) {
			paths.push(item.data.path);
		});
		FR.actions.download(paths);
	}
});