Ext.onReady(function() {
	FR.baseURL = URLRoot+'/?module=metadata&_popup_id='+encodeURIComponent(FR.popupId)+'&filename='+encodeURIComponent(FR.filename)+'&path='+encodeURIComponent(FR.path);
	var fileTypeCombo = new Ext.form.ComboBox({
		fieldLabel: FR.T('File Type'),
		autoCreate:true, mode: 'local',
		emptyText:FR.T('Select...'), value: 0,
		displayField:'filetype', valueField:'id', name: 'file_type_id', hiddenName:'file_type_id',
		editable: false, triggerAction:'all', disableKeyFilter: true, forceSelection:true,
		valueNotFoundText:FR.T('- File Type Not Found -'),
		store: new Ext.data.SimpleStore({
			fields: ['id', 'filetype'],
			data: FR.filetypes
		})
	});
	fileTypeCombo.on('select', function(){
    	var fileTypeId = fileTypeCombo.getValue();
		document.location.href = FR.baseURL+'&fileTypeId='+fileTypeId;
    });

    FR.form = new Ext.form.FormPanel({
	 	autoScroll:true,
        labelAlign: 'right',
		border: false,
		bodyStyle: 'padding:5px',
		defaults: {
			defaults: {
				width: 200
			}
		},
		items: [
			{
	            xtype:'fieldset',
				autoHeight:true,
	            title: FR.T('File Type'),
	            items: [
					fileTypeCombo
				]
			}
		], buttonAlign: 'left',
	    buttons: window.parent.User.perms.read_only ? false : [
			{text: FR.T("Save"), cls: 'fr-btn-default fr-btn-primary',
	        handler: function(){
				FR.viewPort.el.mask(FR.T('Saving data...'));
				Ext.Ajax.request({
					url: FR.baseURL+'&action=save',
					method: 'post',
					params: {formData: Ext.util.JSON.encode(FR.form.getForm().getValues())},
					success: function(req){
						FR.viewPort.el.unmask();
						try {
							var rs = Ext.util.JSON.decode(req.responseText);
						} catch (er){return false;}
						if (rs.msg) {
							window.parent.FR.UI.feedback(rs.msg);
						}
						if (rs.rs) {
							window.parent.FR.utils.reloadGrid();
						}
					}
				});
	        }
		}]
    });
	FR.drawFields();
	if (FR.selectedFileType) {
		fileTypeCombo.setValue(FR.selectedFileType);
	}
	FR.viewPort = new Ext.Viewport({
		layout: 'border',
		hideBorders: true,
		items: [
			{
				region: 'center', layout: 'fit',
				items: FR.form
			}
		]
	});
});