FR.initToolbar = function() {
	/* Labels */
	var labels = [
		{
			text: FR.T('No label'),
			handler: function(item){FR.actions.setLabel('');}
		}
	];
	FR.labels.each(function(label) {
		labels.push({
			text: '<span style="color:'+label.color+';">'+label.text+'</span>', labelInfo: label,
			handler: function(item) {
				FR.actions.setLabel(label.text+'|'+label.color);
			}
		});
	});
	labels.push('-');
	labels.push({
		text: FR.T('Custom label')+'..',
		handler: function() {return false;},
		menu: new Ext.menu.ColorMenu({
			allowReselect: true,
			colors: [
				'000000', '00008B', '0000FF', '8B008B', '8A2BE2', '4682B4', '1E90FF',
				'00FFFF', '006400', '008000', '008B8B', '00FF00', '7FFF00', 'FF0000', 'DC143C',
				'A52A2A', 'FF1493', 'FF4500', 'FF8C00', 'FFFF00', '808080'
			], height: 62,
			handler: function(cm, color){
				new Ext.ux.prompt({
					title: FR.T('Custom label'),
					text: FR.T('Please type the %1label\'s text%2').replace('%1', '<span class="FRLabel" style="background-color:#'+color+';">').replace('%2', '</span>'),
					defaultValue: FR.T('My label'),
					confirmHandler: function(text) {FR.actions.setLabel(text+'|#'+color);}
				});
			}
		})
	});


	/* Grid actions */
	FR.UI.gridActions = {
		refreshExplorer: new Ext.Action({
			text: FR.T('Refresh'), iconCls: 'fa-refresh',
			overflowText: FR.T('Refresh'),
			handler: function() {
				FR.UI.gridPanel.load(FR.currentPath);
				if (FR.currentSection != 'trash' && FR.currentSection != 'starred') {
					if (FR.UI.tree.currentSelectedNode.loading == false && FR.UI.tree.currentSelectedNode.loaded == true) {
						FR.UI.tree.reloadNode(FR.UI.tree.currentSelectedNode);
					}
				}
			}
		}),
		selectAllFiles: new Ext.Action({
			text: FR.T('Select All'), iconCls: 'fa-check-square-o',
			handler: function() {FR.UI.gridPanel.selModel.selectAll();}
		}),
		sortFiles: new Ext.Action({
			text: FR.T('Sort'), iconCls: 'fa-sort',
			handler: function() {
				FR.UI.gridPanel.getView().mainHd.setStyle('display', 'block');
				FR.UI.feedback(FR.T('Use the displayed header bar to sort by the desired field.'));
			}
		}),
		download: new Ext.Action({
			text: FR.T('Download'), iconCls: 'fa-download',
			handler: function() {return FR.actions.downloadSelectedFiles();}
		}),
		preview: new Ext.Action({
			text: FR.T('Preview'), iconCls: 'fa-eye',
			handler: function() {return FR.utils.showPreview();}
		})
	}

	/* "Open with" and "Create" items */
	FR.customActions.unshift({
		actionName: 'open_in_browser',
		title: FR.T('External Window'),
		iconCls: 'fa-external-link',
		requiredUserPerms: ['download'],
		handler: function() {return FR.actions.openFileInBrowser(FR.currentPath+'/'+FR.UI.gridPanel.getOneSel().data.filename);}
	});

	var openWithItems = [];
	var createNewFileItems = [];
	var i=0;
	Ext.each(FR.customActions, function(ca) {
		i++;
		var name = 'custom'+i;
		if (ca.replaceDoubleClickAction) {
			Ext.each(ca.extensions, function(ext) {
				FR.ext[ext] = name;
			});
		}
		FR.UI.gridActions[name] = new Ext.Action({
			text: FR.T(ca.title), icon: ca.icon, iconCls: ca.iconCls,
			handler: function() {return FR.actions.customAction(ca);}
		});
		FR.UI.gridActions[name].settings = ca;
		openWithItems.push(FR.UI.gridActions[name]);
		if (ca.createNew) {
			var show = true;
			Ext.each(ca.requiredUserPerms, function(perm) {
				if (!User.perms[perm]) {show = false;}
			});
			if (show) {
				if (ca.createNew.options) {
					var menu = [];
					Ext.each(ca.createNew.options, function(o) {
						menu.push({
							text: o.title, icon: o.icon, iconCls: o.iconCls,
							handler: function() {return FR.actions.createNew(ca, o.fileName);}
						});
					});
					var handler = function() {return false;};
				} else {
					var menu = false;
					var handler = function() {return FR.actions.createNew(ca);};
				}
				createNewFileItems.push(new Ext.Action({
					text: FR.T(ca.createNew.title), icon: ca.icon, iconCls: ca.iconCls,
					handler: handler, menu: menu
				}));
			}
		}
	});


	var searchMetaFields = [];
	Ext.each(FR.searchMetaColumns, function(item) {
		searchMetaFields.push({
			text: item.n, handler: function () {
				FR.UI.actions.searchField.searchParams.searchType = 'meta';
				FR.UI.actions.searchField.searchParams.metafield = item.id;
				FR.UI.actions.searchField.doSearch();
			}
		});
	});

	if (Settings.fullTextSearch || FR.searchMetaColumns.length > 0) {
		var searchOptsMenu = new Ext.menu.Menu({
			items: [
				{
					text: FR.T('Search file names'),
					handler: function() {
						FR.UI.actions.searchField.searchParams.searchType = 'filename';
						FR.UI.actions.searchField.doSearch();
					}
				},{
					text: FR.T('Search file contents'), hidden: !Settings.fullTextSearch,
					handler: function() {
						FR.UI.actions.searchField.searchParams.searchType = 'contents';
						FR.UI.actions.searchField.doSearch();
					}
				},
				{
					text: FR.T('Search metadata'),
					menu: searchMetaFields, hidden: (FR.searchMetaColumns.length == 0)
				}
			]
		});
	}

	FR.UI.actions = {
		searchField: new FR.components.SearchBox({width: 300, listeners: {
			'show':function(){FR.UI.actions.searchOpts.show();},
			'hide':function(){FR.UI.actions.searchOpts.hide();}
		}}),
		searchOpts: new Ext.Action({
			iconCls: 'fa fa-search fa-fw', cls: 'search-trigger',
			menu: searchOptsMenu,
			handler: function() {
				if (!this.menu) {
					FR.UI.actions.searchField.searchParams.searchType = 'filename';
					FR.UI.actions.searchField.doSearch();
				}
			},
			listeners: {'afterrender': (Settings.fullTextSearch || FR.searchMetaColumns.length > 0) ? FR.UI.tooltip(FR.T('Search options')) : function(){}}
		}),
		logout: new Ext.Action({
			text: FR.T('Sign out')+' <span style="color:gray">('+User.fname+')</span>',
			iconCls: 'fa-sign-out',
			handler:function(){document.location.href = FR.logoutURL;},
			hidden: Settings.hideLogout
		}),
		newDownloadCart: new Ext.Action({
			text: FR.T('Download cart'), iconCls: 'fa-cart-arrow-down',
			handler: function() {
				if (!FR.UI.cart) {FR.UI.cart = new FR.components.cartPanel();}
				FR.UI.cart.show();
			},
			hidden: !User.perms.download
		}),
		cpanel: new Ext.Action({
			text: FR.T('Control Panel'), iconCls: 'fa-cogs',
			handler:function(){
				FR.UI.openInTab({
					src: FR.baseURL+'/?module=cpanel',
					title: FR.T('Control Panel')
				});
			}, hidden: (!User.isAdmin && !User.isIndep)
		}),
		createNewFolder: new Ext.Action({
			text: FR.T('Folder'), iconCls: 'fa-folder',
			handler: function() {
				if (FR.utils.currentFolderAllowsUpload()) {
					FR.UI.tree.editNode = FR.UI.tree.currentSelectedNode;
				} else {
					FR.UI.tree.editNode = FR.UI.tree.homeFolderNode;
				}
				new Ext.ux.prompt({
					title: FR.T('Create new folder'), defaultValue: FR.T('New Folder'),
					confirmHandler: function(folderName) {
						if (folderName) {
							FR.actions.newFolder(FR.UI.tree.editNode, folderName);
						}
					}
				});
			}
		}),
		alerts: new FR.components.infoBtn({
			cls: 'fr-btn-alerts', iconCls: 'fa fa-bell-o fa-fw', text: '&nbsp;', hidden: true,
			listeners: {'afterrender': FR.UI.tooltip('Activity notifications')}
		}),
		weblink: new Ext.Action({
			iconCls: 'fa fa-link fa-fw', hidden: true,
			listeners: {'afterrender': FR.UI.tooltip(FR.T('Get link'))},
			handler: function() {
				var item = FR.UI.gridPanel.getOneSel();
				var path = item.data.path ? item.data.path : FR.currentPath+'/'+item.data.filename;
				return FR.actions.WebLink(item.data.filename, 'file', item, path);
			}
		}),
		preview: new Ext.Action({
			iconCls: 'fa fa-eye fa-fw', hidden: true,
			listeners: {'afterrender': FR.UI.tooltip(FR.T('Preview'))},
			handler: function() {return FR.utils.showPreview();}
		}),
		remove: new Ext.Action({
			iconCls: 'fa fa-trash fa-fw', hidden: true,
			listeners: {'afterrender': FR.UI.tooltip(FR.T('Remove'))},
			handler: function() {return FR.actions.deleteSelected();}
		}),
		more: new Ext.Action({
			iconCls: 'fa fa-ellipsis-v fa-fw', hidden: true,
			listeners: {'afterrender': FR.UI.tooltip(FR.T('More actions'))},
			handler: function() {FR.UI.gridPanel.showContextMenu();return false}
		}),
		moreSep: new Ext.Toolbar.Separator({hidden: true}),
		info: new Ext.Button({
			iconCls: 'fa fa-info-circle fa-fw', cls: 'fr-btn-info', enableToggle: true, pressed: true,
			listeners: {'afterrender': FR.UI.tooltip(FR.T((User.perms.file_history)?'Details and activity':'Details'))},
			toggleHandler: function(btn, toggled) {
				if (toggled) {
					FR.UI.infoPanel.customExpand();
				} else {
					FR.UI.infoPanel.customCollapse();
				}
			}
		}),
		toggleViewList: new Ext.Action({
			iconCls: 'fa fa-list fa-fw',
			listeners: {'afterrender': FR.UI.tooltip(FR.T('List view'))},
			handler: function() {FR.UI.gridPanel.toggleView();}
		}),
		profileSettings: new Ext.Action({
			text: FR.T('Account settings'), iconCls: 'fa-user',
			handler: function() {FR.actions.openAccountSettings();}
		})
	}

	if (Settings.ui_user_logo.length > 0) {
		var logoHTML = FR.UI.getImageLogo(Settings.ui_user_logo);
	} else {
		if (Settings.ui_title_logo) {
			var logoHTML = FR.UI.getTextLogo(Settings.title);
		} else if (Settings.ui_logo_url) {
			var logoHTML = FR.UI.getImageLogo(Settings.ui_logo_url);
		}
	}
	FR.UI.actions.logo = new Ext.Toolbar.TextItem({text: logoHTML});

	var newBtn = {
		text: FR.T('New'), cls: 'fr-btn-new', width: 115,
		hidden: ((!User.perms.upload && User.perms.read_only) ? true : false)
	};
	newBtn.menu = [
		FR.UI.actions.createNewFolder,
		'-',
		{text: FR.T('File upload'), iconCls: 'fa-upload', handler: function() {FR.UI.showUploadForm('files');}},
		{text: FR.T('Folder upload'), iconCls: 'fa-upload', handler: function() {FR.UI.showUploadForm('folder');}}
	];
	if (createNewFileItems.length > 0) {
		newBtn.menu.push('-');
		newBtn.menu.push(createNewFileItems);
	}
	FR.UI.actions.newItem = new Ext.Button(newBtn);


	FR.UI.gridActions.newItem = new Ext.Action({
		text: FR.T('New'), handler: function() {return false},
		menu: newBtn.menu
	});

	FR.UI.gridActions.openWith = new Ext.Action({
		text: FR.T('Open with..'),
		handler: function() {return false},
		menu: {items: openWithItems}
	});

	FR.UI.gridActions.email = new Ext.Action({
		text: FR.T('E-mail'), iconCls: 'fa-envelope-o',
		handler: function() {
			return FR.actions.emailFiles(FR.UI.gridPanel.selModel.getSelections(), FR.currentPath);
		}
	});
	FR.UI.gridActions.weblink = new Ext.Action({
		text: FR.T('Web Link'), iconCls: 'fa-link',
		handler: function() {
			var item = FR.UI.gridPanel.getOneSel();
			var path = item.data.path ? item.data.path : FR.currentPath+'/'+item.data.filename;
			return FR.actions.WebLink(item.data.filename, 'file', item, path);
		}
	});
	FR.UI.gridActions.unweblink = new Ext.Action({
		text: FR.T('Remove Web Links'), iconCls: 'fa-unlink',
		handler: function() {FR.actions.UnWebLink();}
	});
	FR.UI.gridActions.versioning = new Ext.Action({
		text: FR.T('Versioning'), iconCls: 'fa-history',
		handler: function() {return false;},
		menu: new Ext.menu.Menu({
		    id: 'myfiles-contextmenu-versioning',
		    items: [
				new Ext.menu.Item({
					text: FR.T('Previous Versions'),
					handler: function() {return FR.actions.openVersions();}
				}),
				new Ext.menu.Item({
					text: FR.T('Lock'),
					iconCls: 'fa-lock',
					handler: function() {return FR.actions.changeLocking(true);},
					hidden: User.perms.read_only ? true : false
				}),
				new Ext.menu.Item({
					text: FR.T('Unlock'),
					iconCls: 'fa-unlock-alt',
					handler: function() {return FR.actions.changeLocking(false);},
					hidden: User.perms.read_only ? true : false
				})
			]
		})
	});
	FR.UI.gridActions.alog = new Ext.Action({
		text: FR.T('Activity log'), iconCls: 'fa-archive',
		handler: function() {return FR.actions.openActivityLog();}
	});
	FR.UI.gridActions.metadata = new Ext.Action({
		text: FR.T('Metadata'),
		handler: function() {return FR.actions.openMetadata()}
	});
	FR.UI.gridActions.comment = new Ext.Action({
		text: FR.T('Comment'), iconCls: 'fa-comments-o',
		handler: function() {return FR.actions.comments();}
	});
	FR.UI.gridActions.zip = new Ext.Action({
		text: FR.T('Add to zip'), iconCls: 'fa-file-zip-o',
		handler: function() {return FR.actions.zipSelected();}
	});
	FR.UI.gridActions.extract = new Ext.Action({
		text: FR.T('Extract archive'), iconCls: 'fa-file-zip-o',
		handler: function() {return FR.actions.extractSelected();}
	});
	FR.UI.gridActions.copy = new Ext.Action({
		text: FR.T('Copy'),
		handler: function() {return FR.actions.copySelected();}
	});
	FR.UI.gridActions.rename = new Ext.Action({
		text: FR.T('Rename'),
		handler: function() {
			new Ext.ux.prompt({
				title: FR.T('Rename'), defaultValue: FR.currentSelectedFile.data.filename,
				confirmHandler: function(newValue, oldValue) {
					if (newValue && newValue != oldValue) {
						FR.actions.renameSelected(FR.currentSelectedFile.data.filename, newValue);
					}
				}
			});
		}
	});
	FR.UI.gridActions.restore = new Ext.Action({
		text: FR.T('Restore'), icon: FR.iconsURL+'/thumb_up.gif',
		handler: function() {return FR.actions.restoreSelectedFromTrash();}
	});
	FR.UI.gridActions.deleteFile = new Ext.Action({
		text: FR.T('Remove'), iconCls: 'fa-trash',
		handler: function() {return FR.actions.deleteSelected();}
	});
	var a = FR.UI.gridActions;
	FR.UI.gridActions.share = new Ext.Action({
		text: FR.T('Share'), iconCls: 'fa-share-alt',
		handler: function() {return false;},
		menu: [a.weblink, a.email]
	});
	FR.UI.gridActions.label = new Ext.Action({
		text: FR.T('Label'), iconCls: 'fa-tag',
		handler: function() {return false;},
		menu: {items: labels}
	});
	FR.UI.gridActions.locate = new Ext.Action({
		text: FR.T('Locate'), iconCls: 'fa-crosshairs',
		handler: function() {return FR.utils.locateSelected();}
	});
	FR.UI.gridActions.addStar = new Ext.Action({
		text: FR.T('Add star'), iconCls: 'fa-star',
		handler: function() {return FR.actions.star('add');}
	});
	FR.UI.gridActions.removeStar = new Ext.Action({
		text: FR.T('Remove star'), iconCls: 'fa-star-o',
		handler: function() {return FR.actions.star('remove');}
	});
	FR.UI.gridActions.more = new Ext.Action({
		text: FR.T('More options'), iconCls: 'fa-ellipsis-v',
		handler: function() {return false;},
		menu: [a.zip, a.extract, a.versioning, a.alog, a.metadata]
	});
	FR.UI.gridActions.sep1 = new Ext.menu.Separator();
	FR.UI.gridActions.sep2 = new Ext.menu.Separator();
	FR.UI.gridActions.sep3 = new Ext.menu.Separator();
	FR.UI.gridActions.sep4 = new Ext.menu.Separator();
	FR.UI.gridActions.sep5 = new Ext.menu.Separator();
	FR.UI.grid.arrayActions = [a.newItem, a.sep5, a.refreshExplorer, a.selectAllFiles, a.sortFiles, a.locate, a.sep4, a.download, a.preview, a.openWith, a.sep1, a.share, a.comment, a.label, a.addStar, a.removeStar, a.sep2, a.more, a.copy, a.rename, a.restore, a.sep3, a.unweblink, a.deleteFile];


	/* Tree actions */
	FR.UI.tree.actions = {
		download: new Ext.Action({
			text: FR.T('Download'), iconCls: 'fa-download',
			handler: function() {return FR.actions.downloadSelectedFolder();}
		}),
		shareInternal: new Ext.Action({
			text: FR.T('With users'), iconCls: 'fa-user-plus',
			handler: function() {return FR.actions.share();}
		}),
		weblink: new Ext.Action({
			text: FR.T('Web Link'), iconCls: 'fa-link',
			handler: function() {
				if (FR.UI.tree.contextMenuVisible) {
					var treeNode = FR.UI.tree.contextMenuSelectedNode;
				} else {
					var treeNode = FR.UI.tree.currentSelectedNode;
				}
				return FR.actions.WebLink(treeNode.text, 'folder', treeNode, treeNode.getPath('pathname'));
			}
		}),
		email: new Ext.Action({
			text: FR.T('E-mail'), iconCls: 'fa-envelope-o',
			handler: function() {
				if (FR.UI.tree.contextMenuVisible) {
					var treeNode = FR.UI.tree.contextMenuSelectedNode;
				} else {
					var treeNode = FR.UI.tree.currentSelectedNode;
				}
				return FR.actions.emailFiles([treeNode], true);
			}
		}),
		btsync: new Ext.Action({
			text: FR.T('BitTorrent Sync'), iconCls: 'fa-retweet',
			handler: function() {return FR.actions.BTSync();}
		}),
		notifications: new Ext.Action({
			text: FR.T('Notifications'), iconCls: 'fa-bell',
			handler: function() {return false;},
			menu: {
				listeners: {
					'beforeshow': function() {
						var nW = this.items.items[0];
						var nR = this.items.items[1];
						if (FR.UI.tree.contextMenuVisible) {
							var treeNode = FR.UI.tree.contextMenuSelectedNode;
						} else {
							var treeNode = FR.UI.tree.currentSelectedNode;
						}
						if (treeNode.attributes.section == 'sharedFolder') {
							nR.hide();
						} else {
							nR.show();
						}
						if (treeNode.attributes.custom && treeNode.attributes.custom.notInfo) {
							var info = treeNode.attributes.custom.notInfo;
							var cRead = info?info.r:0;
							var cWrite = info?info.w:0;
							nW.setChecked(cWrite, true);
							nR.setChecked(cRead, true);
						}
					}
				},
				items: [
					{xtype: 'menucheckitem', text: FR.T('Upload, Delete, Rename, etc.'), hideOnClick: false, checkHandler: function() {
						FR.actions.saveNotifications([this.ownerCt.items.items[0].checked, this.ownerCt.items.items[1].checked]);
					}},
					{xtype: 'menucheckitem', text: FR.T('Download, Preview, Copy, etc.'), hideOnClick: false, checkHandler: function() {
						FR.actions.saveNotifications([this.ownerCt.items.items[0].checked, this.ownerCt.items.items[1].checked]);
				}}
				]
			}
		}),
		properties: new Ext.Action({
			text: FR.T('Properties'), iconCls: 'fa-cog',
			handler: function() {return FR.actions.folderOptions();}
		}),
		zip: new Ext.Action({
			text: FR.T('Add to zip'), iconCls: 'fa-file-zip-o',
			handler: function() {return FR.actions.zipSelectedFolder();}
		}),
		newFolder: new Ext.Action({
			text: FR.T('New sub-folder'), iconCls: 'fa-folder',
			handler: function() {
				FR.UI.tree.editNode = FR.UI.tree.contextMenuSelectedNode;
				new Ext.ux.prompt({
					title: FR.T('New sub-folder'), defaultValue: FR.T('New Folder'),
					confirmHandler: function(folderName) {
						if (folderName) {
							FR.actions.newFolder(FR.UI.tree.editNode, folderName);
						}
					}
				});
			}
		}),
		copy: new Ext.Action({
			text: FR.T('Copy'),
			handler: function() {return FR.actions.copySelected(true);}
		}),
		pasteFolder: new Ext.Action({
			text: FR.T('Paste copied folder'),
			handler: function() {return FR.actions.pasteCopied(false, true);}
		}),
		pasteFiles: new Ext.Action({
			text: FR.T('Paste copied files'),
			handler: function() {return FR.actions.pasteCopied();}
		}),
		rename: new Ext.Action({
			text: FR.T('Rename'),
			handler: function() {
				if (FR.UI.tree.contextMenuVisible) {
					FR.UI.tree.editNode = FR.UI.tree.contextMenuSelectedNode;
				} else {
					FR.UI.tree.editNode = FR.UI.tree.currentSelectedNode;
				}
				new Ext.ux.prompt({
					title: FR.T('Rename'), defaultValue: FR.UI.tree.editNode.text,
					confirmHandler: function(newValue, oldValue) {
						if (newValue && newValue != oldValue) {
							FR.actions.renameFolder(FR.UI.tree.editNode, newValue);
						}
					}
				});
			}
		}),
		deleteFolder: new Ext.Action({
			text: FR.T('Delete'), iconCls: 'fa-trash',
			handler: function() {return FR.actions.deleteFolder();}
		}),
		sep1: new Ext.menu.Separator(),
		sep2: new Ext.menu.Separator(),
		sep3: new Ext.menu.Separator()
	};

	var a = FR.UI.tree.actions;
	FR.UI.tree.actions.share = new Ext.Action({
		text: FR.T('Share'),  iconCls: 'fa-share-alt',
		handler: function() {return false;},
		menu: [a.weblink, a.email, a.shareInternal, a.btsync]
	});

	FR.UI.tree.actions.more = new Ext.Action({
		text: FR.T('More'),  iconCls: 'fa-ellipsis-v',
		handler: function() {return false;},
		menu: [a.zip, a.copy, a.notifications, a.properties]
	});
	FR.UI.tree.actions.addStar = new Ext.Action({
		text: FR.T('Add star'),  iconCls: 'fa-star',
		handler: function() {return FR.actions.star('add');}
	});
	FR.UI.tree.actions.removeStar = new Ext.Action({
		text: FR.T('Remove star'),  iconCls: 'fa-star-o',
		handler: function() {return FR.actions.star('remove');}
	});
	FR.UI.tree.arrayActions = [a.newFolder, a.sep1, a.share, a.more, a.addStar, a.removeStar, a.pasteFolder, a.pasteFiles, a.rename, a.sep2, a.download, a.sep3, a.deleteFolder];


	/* Header toolbar */
	FR.UI.headerTBar = new Ext.Toolbar({
		height: 60,
		plain: true, cls: 'headerTbar noselect',
		items: [
			FR.UI.actions.logo,
			FR.UI.actions.searchField,
			FR.UI.actions.searchOpts,
			'->',
			FR.UI.actions.weblink,
			FR.UI.actions.preview,
			FR.UI.actions.remove,
			FR.UI.actions.more,
			FR.UI.actions.moreSep,
			FR.UI.actions.alerts,
			FR.UI.actions.toggleViewList,
			FR.UI.actions.info,
			new Ext.Button({
				iconCls: 'fa fa-cog fa-fw', cls: 'fr-btn-user-settings',
				listeners: {'afterrender': FR.UI.tooltip(FR.T('Settings'))},
				menu: [
					FR.UI.actions.newDownloadCart,
					FR.UI.actions.cpanel,
					FR.UI.actions.profileSettings,
					FR.UI.actions.logout
				]
			})
		]
	});
}