FR = {
	step: 0,
	T: function(s) {return s;}
};
Ext.onReady(function() {
	FR.win = new Ext.Window({
		title: 'FileRun - Installation',
		width: 400, height: 250, buttonAlign: 'left',
		closable: false, resizable: false, draggable: false, hideBorders: true,
		layout: 'card', activeItem: 0,
		items: [
			{
				html: '<div style="margin:10px;font-size:12px;"><span style="font-size:16px;font-weight:bold">Welcome to '+appName+'!</span><br><br>This wizard will help you install the software in three easy steps.<br><br>By installing '+appName+' you are agreeing to the terms detailed in the following document: <a href="'+licenseAgreementURL+'" target="_blank">License_Agreement.pdf</a><br><br>Click "Next" to proceed.</div>'
			},
			{
				id: 'reqPanel', bodyStyle: 'padding: 10px', autoScroll: true,
				html: ''
			},
			{
				xtype: 'form', bodyStyle: 'padding: 10px',
				hideLabels: true,
				items: [
					{xtype: 'displayfield', value: '<div style="font-size:12px;"><h2>Step: 2/3</h2><br>Please type in the received license key and client password, then click "Next":</div>'},
					{xtype: 'displayfield', value: 'License key:', cls: 'loginFormLabel'},
					{
						xtype: 'textfield', id: 'licensekey', name:'licensekey', value: '',
						tabIndex: 1, style: 'font-size:16px;', height:30, width: 360
					},
					{xtype: 'displayfield', value: 'Client password:', cls: 'loginFormLabel'},
					{
						xtype: 'textfield', id: 'clientp', name:'clientp', value: '',
						inputType: 'password', tabIndex: 2, style: 'font-size:16px;', height:30, width: 360
					}
				]
			},
			{
				xtype: 'form', id:'mysqlFrm', bodyStyle: 'padding: 10px', labelAlign: 'right', autoScroll: true, labelWidth: 150,
				items: [
					{xtype: 'displayfield', hideLabel: true, value: '<div style="font-size:12px;"><h2>Last Step</h2><br>Please type in your MySQL server connection information:</div>'},
					{xtype: 'displayfield', height: 20},
					{
						xtype: 'textfield', name:'host', width: 200, value: 'localhost', fieldLabel: 'MySQL Hostname'
					},
					{
						xtype: 'textfield', name:'dbname', width: 200,value: '', fieldLabel: 'Database name'
					},
					{
						xtype: 'textfield', name:'user', width: 200,value: '', fieldLabel: 'User name'
					},
					{
						xtype: 'textfield', name:'pass', width: 200,value: '', fieldLabel: 'Password'
					},
					{xtype: 'displayfield', height: 20},
					{xtype: 'displayfield', hideLabel: true, value: 'The database will be automatically created if it doesn\'t exist.<br>The table names are prefixed with "df_".'}
				]
			},
			{
				id: 'successPanel', bodyStyle: 'padding: 10px', html: ''
			}
		],
		buttons: [
			{
				id: 'backBtn',
				text: '<span style="font-size:15px;font-weight:bold">Back</span>',  tabIndex: 3,
				style: 'font-size:15px', scale: 'medium',
				hidden: true,
				handler: function() {
					if (FR.step == 1) {
						FR.step = 0;
						FR.win.setSize(400, 250).anchorTo(Ext.get('theBODY'), 'c-c');
					} else if (FR.step == 2) {
						FR.step = 1;
						FR.win.setSize(600, 360).anchorTo(Ext.get('theBODY'), 'c-c');
					} else if (FR.step == 3) {
						FR.step = 2;
					} else if (FR.step == 4) {
						FR.step = 3;
					}
					FR.win.getLayout().setActiveItem(FR.step);
					if (FR.step == 0) {
						this.hide();
					}
				}
			},
			new Ext.Toolbar.Fill(),
			{
				text: '<span style="font-size:15px;font-weight:bold">Next</span>',  tabIndex: 3, 
				cls: 'fr-btn-default fr-btn-primary',
				handler: function(){
					if (FR.step == 0) {
						FR.step1();
					} else if (FR.step == 1) {
						FR.win.setSize(410, 330).anchorTo(Ext.get('theBODY'), 'c-c');
						FR.win.getLayout().setActiveItem(2);
						FR.step = 2;
					} else if (FR.step == 2) {
						Ext.get(FR.win.body).mask('Verifying license key...');
						Ext.Ajax.request({
							url: URLRoot+'/?module=install&page=index&action=applyKey',
							params: {
								lkey: Ext.getCmp('licensekey').getValue(),
								cp: Ext.getCmp('clientp').getValue()
							},
							callback: function() {Ext.get(FR.win.body).unmask();},
							success: function(resp) {
								try {
									var rs = Ext.util.JSON.decode(resp.responseText);
								} catch (er) {
									if (confirm('Unexpected server reply. Press "OK" to display it.')) {
										document.write(resp.responseText);
									}
								}
								if (rs.success) {
									new Ext.ux.prompt({
										title: 'Thank you for choosing FileRun!',
										text: rs.msg
									});
									FR.step3();
								} else if (rs.success == false) {
									new Ext.ux.prompt({
										text: rs.msg
									});
								}
							},
							failure: function(frm, act) {document.write(resp.responseText);}, scope: this
						});
					} else if (FR.step == 3) {
						FR.step4();
					} else if (FR.step == 4) {
						document.location.href = URLRoot+'/?username=admin&password=admin';
					}
				}
			}
		]
	});
	FR.step1 = function() {
		Ext.get(FR.win.body).mask('Checking server requirements...');
		Ext.Ajax.request({
			url: URLRoot+'/?module=install&page=requirements',
			params: {lkey: Ext.getCmp('licensekey').getValue()},
			callback: function(opt, success, resp) {
				FR.step = 1;
				Ext.getCmp('backBtn').show();
				Ext.get(FR.win.body).unmask();
				FR.win.setSize(600, 360).anchorTo(Ext.get('theBODY'), 'c-c');
				FR.win.getLayout().setActiveItem(1);
				Ext.getCmp('reqPanel').update(resp.responseText);
			}, scope: this
		});
	}
	FR.step3 = function() {
		FR.win.setSize(450, 400).anchorTo(Ext.get('theBODY'), 'c-c');
		FR.win.getLayout().setActiveItem(3);
		FR.step = 3;
	}
	FR.step4 = function() {
		Ext.get(FR.win.body).mask('Setting up database...');
		Ext.Ajax.request({
			url: URLRoot+'/?module=install&page=mysql_setup',
			params: Ext.getCmp('mysqlFrm').getForm().getValues(),
			callback: function() {
				Ext.get(FR.win.body).unmask();
			},
			success: function(resp) {
				try {
					var rs = Ext.util.JSON.decode(resp.responseText);
				} catch (er) {
					if (confirm('Unexpected server reply. Press "OK" to display it.')) {
						document.write(resp.responseText);
					}
				}
				if (rs.success) {
					FR.step = 4;
					Ext.getCmp('successPanel').update('<div style="font-size:12px;"><span style="font-size:18px;font-weight:bold">Done!</span><br><br>'+appName+' has been successfully installed on your server. <br><br>The superuser account "<span style="font-weight:bold">admin</span>" was created.<br>Its password is "<span style="font-weight:bold">admin</span>" <br><br>To manage files that are already on your web server, you can change the superuser\'s home folder path from the control panel.<br><br>Click "Next" to close this wizard and open the login page.</div>');
					FR.win.getLayout().setActiveItem(4);
					Ext.getCmp('backBtn').hide();
				} else if (rs.success == false) {
					new Ext.ux.prompt({
						text: rs.msg
					});
				}
			},
			failure: function(frm, act) {document.write(resp.responseText);}, scope: this
		});
	}
	FR.win.show();
	FR.win.anchorTo(Ext.get('theBODY'), 'c-c');
});