Ext.define('FileRun.controller.app', {
	extend: 'Ext.app.Controller',
	config: {
        refs: {
			loginView: 'loginview',
            loginBtn: 'button[action=login]',
			loginFrm: '#loginFrm'
        },
        control: {loginBtn: {tap: 'onTapLoginBtn'}}
    },
    onTapLoginBtn: function(button) {this.login();},
	'launch': function() {
		if (!User.id) {
			this.showLogin();
		} else {
			this.initApp();
		}
		FR.customActions = {};
		FR.ext = {};
		Ext.each(FR.customActions, function(ca) {
			var name = ca.actionName;
				Ext.each(ca.extensions, function(ext) {
					if (!FR.ext[ext]) {FR.ext[ext] = [];}
					FR.ext[ext].push(name);
				});
			FR.customActions[name] = ca;
		});
	},
	'showLogin': function() {
		if (!this.loginView) {
			this.loginView = Ext.create('FileRun.view.LoginForm');
			this.loginForm = this.getLoginFrm();
			Ext.Viewport.add(this.loginView);
			Ext.Viewport.unmask();
		}
		Ext.Viewport.setActiveItem(this.loginView);
	},
	'initApp': function() {
		if (!this.mainView) {
			this.mainView = Ext.create('FileRun.view.Main');
			Ext.Viewport.add(this.mainView);
		}
		Ext.Viewport.setActiveItem(this.mainView);
	},
	'setMasked': function(){},//stupid workaround
	'login': function() {
		Ext.Viewport.mask();
		this.loginForm.submit({
			url: '../?module=fileman&section=default&page=login&action=login',
			method: 'POST',
			success: function(form, rs) {
				Ext.Viewport.unmask();
				var fields = this.loginForm.getFields();
				fields.username.setValue('');
				fields.password.setValue('');
				if (fields.language.getValue() != selectedLang) {
					document.location.href = URLRoot+'/?language='+encodeURIComponent(fields.language.getValue());
				} else {
					this.initApp();
				}
			},
			failure: function(form, rs) {
				var fn;
				Ext.Viewport.unmask();
				if (rs.ask_otp) {
					fn = function() {
						var fields = this.loginForm.getFields();
						fields.otp.show();
					}
				}

				if (rs.twoStepSecret) {
					fn = function() {
						Ext.Msg.prompt(FR.T('2-step verification: add account'), FR.T('Type the following key code into your authentication app:'), function(){
							var fields = this.loginForm.getFields();
							fields.two_step_secret.setValue(rs.twoStepSecret);
							fields.otp.show();
						}, this, false, rs.twoStepSecret);
					}
				}
				Ext.Msg.alert(FR.T('Login'), rs.error, fn, this);
			}, scope: this
		});
	},
	'logout': function() {
		Ext.Viewport.mask();
		Ext.Ajax.request({
			url: '?page=logout',
			callback: function() {Ext.Viewport.unmask();},
			success: function(response, opts) {
				try {
				var rs = Ext.decode(response.responseText);
				} catch (er){return false;}
				if (rs.rs) {
					this.showLogin();
				}
			}, scope: this
		});
	},
	'openLinkInNewWindow': function(url) {
		//awful hack to avoid pop-up blocking by smart phone browser.
		var lnk = Ext.getDom('hidden_link');
		var clickevent = document.createEvent('Event');
		lnk.href = url;
		clickevent.initEvent('click', true, false);
		lnk.dispatchEvent(clickevent);
	},
	getThumbURL: function(itemData) {
		//append &v=2 when the thumb image style changes
		var url = '../t.php?sn=1&p='+encodeURIComponent(itemData.path);
		if (itemData.filesize) {
			url += '&s='+itemData.filesize;
		}
		if (itemData.modified) {
			var timestamp = new Date(itemData.modified).getTime()/1000;
			url += '&t='+timestamp;
		}
		if (itemData.extra) {
			url += '&'+itemData.extra;
		}
		return url;
	}
});