Ext.define('FileRun.view.UploadForm', {
	xtype: 'uploadform',
	extend: 'Ext.Panel',
	config: {
		modal: true, hideOnMaskTap: true, layout: 'fit',
		styleHtmlContent: true, html: '<form action="?page=upload&action=upload" method="post" enctype="multipart/form-data" target="hIframe" id="theUploadForm" name="theUploadForm"><input type="hidden" id="uploadPath" name="path"><input type="file" id="fileChooser" name="userfile[]"></form>',
		listeners: {
			show: function() {
				Ext.get('hIframe').dom.addEventListener('load', function() {
					Ext.Viewport.unmask();
					Ext.get('theUploadForm').dom.reset();
					FileRun.app.getController('FileRun.controller.FileList').hideUploadForm();
					if (this.contentWindow) {
						if (this.contentWindow.document) {
							if (this.contentWindow.document.body.innerHTML) {
								var rs = Ext.decode(this.contentWindow.document.body.innerText);
								if (rs.rs) {
									FileRun.app.getController('FileRun.controller.FileList').reload();
								}
								Ext.Msg.alert(FR.T('Upload'), rs.msg);
							}
						}
					}
				});
				Ext.get('fileChooser').dom.addEventListener('change', function(){
					Ext.Viewport.mask();
					Ext.get('uploadPath').dom.value = FR.currentPath;
					Ext.get('theUploadForm').dom.submit();
				});
			}
		}
	},
	initialize: function() {this.callParent(arguments);}
});